package com.aote.logic;

import com.aote.ThreadResource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * logic映射器
 */
public class LogicMapper {

	static Logger LOGGER = Logger.getLogger(LogicMapper.class);

	private static Map<String, Map<String, String>> map;

	static {
		//初始化即加载
		loadMap();
	}

	public static String getLogic(String alias) {
		if (map.containsKey(alias)){
			String result = getLogicByUser(alias);
			if(result != null) {
				return result;
			}
			return map.get(alias).get("path");
		}
		else {
			return null;
		}
	}

	public static Map<String, Map<String, String>> getMap() {
		return LogicMapper.map;
	}

	public static String getAttr(String alias, String name) {
		if (map.containsKey(alias)) {
			return map.get(alias).get(name);
		} else {
			return null;
		}
	}

	public  static String getLogicByUser(String alias){
		//获取登陆用户用户名
		String dir = ThreadResource.ComponentDir.get();
		if (dir == null) {
			return null;
		}
		//查看对应目录下是否存在相关logic
		String path = "/" + dir + "/logics/" +alias + ".logic";
        // 查看是否已经读取了分公司的logic  如果获取到直接返回
        if (map.containsKey(dir + '_' + alias)) {
            return map.get(dir + '_' + alias).get("path");
        } else {
            SAXReader reader = new SAXReader();
            // 获取分公司的xml文件 并读取
            try {
				parseOneModule(dir, reader, "filiale", true);
                // 读取完分公司文件 重新获取logic
                if (map.containsKey(dir + '_' + alias)) {
                    return map.get(dir + '_' + alias).get("path");
                }
            } catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("获取分公司配置文件异常:" + path);
            }
        }
		if (LogicMapper.class.getResource(path) != null) {
			return path;
		}
		return null;
	}

	// 加载映射文件
	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<>();

		SAXReader reader = new SAXReader();
		// 加载模块定义文件
		InputStream module = LogicMapper.class.getClassLoader()
				.getResourceAsStream("module.xml");
		try {
			// 有模块定义文件，先处理模块定义文件
			if (module != null) {
				parseModule(module);
			}
			// 加载业务逻辑定义文件
			InputStream input = LogicMapper.class.getClassLoader()
					.getResourceAsStream("logic.xml");
			// 有业务逻辑定义文件，从业务逻辑定义文件中获取业务逻辑，存放到全局map中
			if (input != null) {
                loadOneMap(input, reader, null, null, false);
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}

	}

	// 从业务逻辑定义文件中获取业务逻辑定义内容，存放到全局map中
	// name, parent: 用于加载模块中到业务逻辑时，指明到前缀
	private static void loadOneMap(InputStream input, SAXReader reader, String name, String parent, Boolean isFiliale) throws Exception {
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("logic"); it.hasNext();) {
			Element element = (Element) it.next();
			String aliasLogic = element.attribute("alias").getValue();
            if (isFiliale) {
                // 如果是分公司获取 重新给别名赋值
                aliasLogic = name + "_" + aliasLogic;
            }
			String pathLogic = element.attribute("path").getValue();
			String log = element.attributeValue("log");
			String mobile = element.attributeValue("mobile");
			// 获取业务逻辑书写语言，包括：func、expression，没有值，就为null，代表exprssion
			String language = element.attributeValue("language");

			// 验证别名是否重复(只验证module模块)
			if (name != null && map.containsKey(aliasLogic)) {
				throw new Exception("别名" + aliasLogic + "已存在");
			}

			String path = getPath(name, parent, pathLogic);

			// 设置业务逻辑属性
			Map<String, String> logic = new HashMap<>();
			logic.put("alias", aliasLogic);
			logic.put("path", path);
			logic.put("log", log);
			logic.put("mobile", mobile);
			// 设置语言属性，空代表expression
			logic.put("language", language);
			map.put(aliasLogic, logic);
		}
	}

	// 根据模块名等内容获取业务逻辑路径
	// name, parent: 加载模块中业务逻辑时，需要等模块名，父模块名信息，如果没有，name为空
	// path：从配置文件中读取到的路径
	private static String getPath(String name, String parent, String path) {
		// 不是模块中的内容
		if (name == null) {
			return "logics/" + path;
		} else if (parent == null) {
			return name + "/logics/" + path;
		} else {
			// 如果有parent，把parent添加到前面
			return parent + "/" + name + "/logics/" + path;
		}
	}

	// 解析模块文件
	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		// 处理第一级模块
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
            parseOneModule(name, reader, null, false);
			// 处理本模块下到第二级模块
			for (Iterator children = elm.elementIterator("module"); children
					.hasNext();) {
				Element childElm = (Element) children.next();
				String childname = childElm.attribute("name").getValue();
                parseOneModule(childname, reader, name, false);
			}
		}
	}

	// 处理一个模块内容
    private static void parseOneModule(String name, SAXReader reader, String parent, boolean isFiliale)
			throws Exception {

		String str = (parent == null ? name + "/logic.xml" : parent + "/"
				+ name + "/logic.xml");

		// 读取模块文件到内容
		InputStream moduleLogic = LogicMapper.class.getClassLoader()
				.getResourceAsStream(str);

		if (moduleLogic == null) {
			throw new RuntimeException("注意！！！找不到文件：" + str);
		}
		// 处理一个logic.xml文件内容
        loadOneMap(moduleLogic, reader, name, parent, isFiliale);
	}
}
