package com.aote.util;

import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.internal.PersistentSet;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.*;

public class JsonTransfer {
	private final List<Map<String, Object>> transed = new ArrayList<>();

	@SuppressWarnings("unchecked")
	public static JSONObject MapToJson(Map<String, Object> map) {
		return new JSONObject(map);
	}

	@SuppressWarnings("unchecked")
	public Object ToJson(PersistentSet set) {
		if (!set.wasInitialized()) {
			return JSONObject.NULL;
		}
		JSONArray array = new JSONArray();
		for (Object obj : set) {
			Map<String, Object> map = (Map<String, Object>) obj;
			JSONObject json = MapToJson(map);
			array.put(json);
		}
		return array;
	}

	@SuppressWarnings("unchecked")
	private Object ToJson(PersistentList list) {
		if (!list.wasInitialized()) {
			return JSONObject.NULL;
		}
		JSONArray array = new JSONArray();
		for (Object obj : list) {
			if (obj == null) {
                continue;
            }
			Map<String, Object> map = (Map<String, Object>) obj;
			JSONObject json = MapToJson(map);
			array.put(json);
		}
		return array;
	}

	public boolean contains(Map<String, Object> obj) {
		for (Map<String, Object> map : this.transed) {
			if (obj == map) {
				return true;
			}
		}
		return false;
	}
}
