package com.aote.rs;

import com.aote.exception.FileNotFoundException;
import com.aote.manager.DatabaseServer;
import com.aote.manager.LogicServer;
import com.aote.manager.SQLServer;
import com.aote.manager.VueServer;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import java.io.IOException;

/**
 * 提供sql查询服务
 */
@Path("manager")
@Component
public class ManagerService {
	static Logger log = Logger.getLogger(ManagerService.class);

	/**
	 * 从hibernate中读取数据库表信息
	 */
	@GET
	@Path("database")
	public String getDatabase() {
		DatabaseServer server = new DatabaseServer();
		return server.getDatabases().toString();
	}

	/**
	 * 获取SQL语句信息
	 */
	@GET
	@Path("sql")
	public String getSQL() {
		SQLServer server = new SQLServer();
		return server.getData().toString();
	}

	/**
	 * 获取业务逻辑信息
	 */
	@GET
	@Path("logic")
	public String getLogic() {
		LogicServer server = new LogicServer();
		return server.getData().toString();
	}

	/**
	 * 获取前台组件信息
	 */
	@GET
	@Path("vue")
	public String getVue() {
		VueServer server = new VueServer();
		return server.getData().toString();
	}

	/**
	 * 获取系统环境运行配置信息
	 */
	@GET
	@Path("config")
	public String getConfig() {
		String result = null;
		try {
			result = ResourceHelper.getString("systemConfig.json");
		} catch (FileNotFoundException e) {
			throw new RuntimeException("systemConfig文件无配置");
		} catch (IOException io) {
			throw new RuntimeException(io);
		}
		// 去掉json中的注释
		result = result.replaceAll("#[^\n]*", "");
		return result;
	}
}
