package com.aote.rs;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Path("log")
@Component
public class LogService {
    static final Logger log = Logger.getLogger(LogService.class);

    /**
     * 该方法接收一个字符串数据并以 时间-HTML页面错误: xxxxxx打印到日志中
     * 方法并不算太安全，可能会导致日志写满磁盘。
     * 以下为前台Listener组件传入的格式：
     * 错误信息： Uncaught ReferenceError: ccc is not defined
     * 出错文件： <a href="http://localhost:8080/index.html">...</a>       //出错的url
     * 错误详情： ReferenceError: ccc is not defined
     * at index.html:15
     */
    @POST
    @Path("html")
    public String htmlLogException(String message) {
        log.error("HTML页面错误:" + message);
        return "";
    }

    @POST
    @Path("android")
    public String androidLogException(String message) {
        log.error("安卓错误:" + message);
        return "";
    }

    @POST
    @Path("ios")
    public String iosLogException(String message){
        log.error("ios错误:"+message);
        return "";
    }
}
