package com.aote.module;

import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.util.ResourceHelper;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModuleMapper {

	static Logger log = Logger.getLogger(LogicMapper.class);

	private static Map<String, Map<String, String>> map;
	private static Map<String, Map<String, String>> subclassmap;

	public static synchronized String getAttr(String module, String attr) {
		if (map == null) {
            loadMap();
        }
		if (map.containsKey(module)) {
            return map.get(module).get(attr);
        } else {
            return null;
        }
	}
	/**
	 * 获取继承关系模块配置文件
	 * @return
	 */
	public static synchronized  Map<String, Map<String, String>> getSubClassMap() {
		if (subclassmap == null) {
            loadSubClassMap();
        }
		return subclassmap;
	}
	
	/**
	 * 获取所有模块映射文件
	 * @return
	 */
	public static synchronized  Map<String, Map<String, String>> getMap() {
		if (map == null) {
            loadMap();
        }
		return map;
	}
	
	// 找到跟目下的subclass.json并解析
	private static void loadSubClassMap() {
		subclassmap = new HashMap<>();

        if (ResourceHelper.class.getResourceAsStream("/"+ "subclass.json") == null) {
            log.debug("无subclass.json文件，继承关系模块化无");
            return;
        }
        String strConfig = null;
		try {
			strConfig = ResourceHelper.getString("subclass.json");
		} catch (FileNotFoundException e) {
			throw new RuntimeException("subclass.json文件无配置");
		} catch (IOException io) {
			throw new RuntimeException(io);
		}

        JSONArray json = new JSONArray(strConfig);	
        for (Object obj : json) {
        	  JSONObject jo = (JSONObject)obj;
        	  String name = jo.getString("module");
  			  Map<String, String> module = new HashMap<>();
  			  module.put("name", name);
  			  subclassmap.put(name, module); 
        	}
	}
	

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<>();

		InputStream module = LogicMapper.class.getClassLoader()
				.getResourceAsStream("module.xml");
		try {
			if (module == null) {
				throw new RuntimeException("模块定义文件module.xml未找到");
			}
			parseModule(module);
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}

	}

	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
			String upload = elm.attributeValue("upload");
			// 设置module属性
			Map<String, String> module = new HashMap<>();
			module.put("name", name);
			module.put("upload", upload);
			map.put(name, module);
		}
	}
}
