package com.aote.rs;

import cn.hutool.core.util.StrUtil;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.util.SingleTableTool;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.util.ArrayList;

/**
 * @Author: JoeCdy
 * @Description: 单表查询服务
 * @Date: Created in 13:59 2022/9/19
 */
@Path("single")
@Singleton
@Component
@Transactional
public class SingleService {

    static Logger log = Logger.getLogger(SingleService.class);

    @Autowired
    private LogicService logicService;

    @Autowired
    private SqlServer sqlServer;

    /**
     * 执行单表查询业务逻辑
     *
     * @param logicName 业务逻辑名称
     * @param values    JSON资源字符串{model: {}(表单对象),pageNo: int(页码),pageSize: int(每页数量),lsNumber: (int)需要的临时表数量}
     * @return 执行结果
     */
    @POST
    @Path("{logic}")
    public Response query(@PathParam("logic") String logicName, String values, @Context HttpServletRequest request) {
        ArrayList<String> lsTablesName = null;
        try {
            JSONObject param = new JSONObject(values);
            // 临时表名参数传入业务逻辑
            if (!param.isNull("data")) {
                Object dataParam = param.get("data");
                if (dataParam instanceof JSONObject) {
                    param = (JSONObject) dataParam;
                }
            }
            // 需要使用的临时表数量, 不传默认给3个
            int lsNumber = param.optInt("lsNumber", 3);
            lsTablesName = SingleTableTool.temporaryName(lsNumber);
            param.put("nameList", lsTablesName);
            return logicService.xtSave(logicName, param.toString(), request);
        } catch (Exception e) {
            log.debug("单表查询执行异常:", e);
            throw new WebException(500, "查询异常");
        } finally {
            if (lsTablesName != null) {
                int n = -1;
                try {
                    // oracle结束临时表占用
//                    String query = "select sid, serial# from v$session where sid in (SELECT SID FROM V$LOCK WHERE ID1 in (SELECT OBJECT_ID FROM USER_OBJECTS WHERE OBJECT_NAME in ({})))";
//                    String union = CommonTools.union(new JSONArray(lsTablesName));
//                    query = StrUtil.format(query, union);
//                    JSONArray session = sqlServer.querySQL(query);
//                    String begin = "BEGIN\n{}END;";
//                    String alter = "execute immediate 'ALTER SYSTEM KILL SESSION ''{}, {}''';\n";
//                    StringBuilder sql = new StringBuilder();
//                    for (int i = 0; i < session.length(); i++) {
//                        JSONObject json = session.getJSONObject(i);
//                        String sid = StrUtil.format(alter, json.get("sid"), json.get("serial#"));
//                        sql.append(sid);
//                    }
                    // 删除临时表
                    String deleteSql = "BEGIN\n{}END;";
                    String tem1 = "execute immediate 'TRUNCATE TABLE {}';\n";
                    String tem2 = "execute immediate 'drop table {}';\n";
                    StringBuilder sql = new StringBuilder();
                    for (int i = 0; i < lsTablesName.size(); i++) {
                        String name = lsTablesName.get(i);
                        String format1 = StrUtil.format(tem1, name);
                        String format2 = StrUtil.format(tem2, name);
                        sql.append(format1).append(format2);
                    }
                    deleteSql = StrUtil.format(deleteSql, sql);
                    n = sqlServer.runSQL(deleteSql);
                } catch (Exception e) {
                    // 删除异常无所谓,当有没用临时表时就会报错,吞掉
                    log.debug("临时表删除异常:" + e.getMessage());
                }
                log.debug("临时表删除: " + n);
            }
        }
    }

}
