/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.ThreadResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SqlMapper {
    static Logger log = Logger.getLogger(SqlMapper.class);
    private static Map<String, Map<String, String>> map;

    public static synchronized String getSql(String alias) {
        if (map == null) {
            SqlMapper.loadMap();
        }
        if (map.containsKey(alias)) {
            String result = SqlMapper.getSqlByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static synchronized String getAttr(String alias, String name) {
        if (map == null) {
            SqlMapper.loadMap();
        }
        if (map.containsKey(alias)) {
            return map.get(alias).get(name);
        }
        return null;
    }

    public static synchronized Map<String, Map<String, String>> getMap() {
        if (map == null) {
            SqlMapper.loadMap();
        }
        return map;
    }

    public static String getSqlByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/sqls/" + alias + ".sql";
        if (SqlMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = SqlMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                SqlMapper.parseModule(module);
            }
            if ((input = SqlMapper.class.getClassLoader().getResourceAsStream("sql.xml")) != null) {
                SqlMapper.loadOneMap(input, reader, null, null);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void loadOneMap(InputStream input, SAXReader reader, String name, String parent) throws Exception {
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("sql");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String aliasLogic = element.attribute("alias").getValue();
            String pathLogic = element.attribute("path").getValue();
            String mobile = element.attributeValue("mobile");
            String language = element.attributeValue("language");
            if (map.containsKey(aliasLogic)) {
                throw new Exception("\u522b\u540d" + aliasLogic + "\u5df2\u5b58\u5728");
            }
            String path = SqlMapper.getPath(name, parent, pathLogic);
            HashMap<String, String> logic = new HashMap<String, String>();
            logic.put("alias", aliasLogic);
            logic.put("path", path);
            logic.put("mobile", mobile);
            logic.put("language", language);
            map.put(aliasLogic, logic);
        }
    }

    private static String getPath(String name, String parent, String path) {
        if (name == null) {
            return "sqls/" + path;
        }
        if (parent == null) {
            return name + "/sqls/" + path;
        }
        return parent + "/" + name + "/sqls/" + path;
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            SqlMapper.putMap(name, reader, null);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                SqlMapper.putMap(childname, reader, name);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        String str = parent == null ? name + "/sql.xml" : parent + "/" + name + "/sql.xml";
        InputStream moduleSql = SqlMapper.class.getClassLoader().getResourceAsStream(str);
        if (moduleSql == null) {
            throw new RuntimeException("\u6ce8\u610f\uff01\uff01\uff01\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + str);
        }
        SqlMapper.loadOneMap(moduleSql, reader, name, parent);
    }

    public void main(String[] args) {
        SqlMapper.loadMap();
        for (String key : map.keySet()) {
            System.out.println(key);
        }
    }
}

