package com.aote.util.dialect;

/**
 * Oracle数据源方言兼容性组件
 */
public class OracleDialect extends DataSourceDialect {

    @Override
    public String getSql(String sql) {
        sql = sql.replaceAll("(isnull|ISNULL)","nvl")
        //        .replace("+","||")
                .replaceAll("(substring|SUBSTRING)","substr")
                .replaceAll("(getdate|GETDATE)\\(\\)","sysdate")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*numeric\\s*\\(\\s*\\d+\\s*,\\s*\\d+\\s*\\)\\s*,{1}","to_number(")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*decimal\\s*\\(\\s*\\d+\\s*,\\s*\\d+\\s*\\)\\s*,{1}","to_number(")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*varchar\\s*,{1}\\s*('?[0-9a-zA-Z_\\-\\s:\\.]+'?)\\s*,\\s*\\d+\\s*\\)","to_date($2)")   //处理convert(varchar,'2020-01-22 00:00:01',103)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*varchar\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*('?[0-9a-zA-Z_\\-\\s:\\.]+'?)\\s*,\\s*\\d+\\s*\\)","to_date($2)")  //处理 convert(varchar(123),'2020-01-22 00:00:01',103)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*varchar\\s*,{1}","to_char(")   //处理convert(varchar,xxx)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*varchar\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}","to_char(")  //处理convert(varchar(22),xxx)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,{1}","to_date(")  //处理convert(varchar(22),xxx)
                .replaceAll("(cast|CAST)\\s*\\(\\s*(['a-zA-Z0-9_\\.]+)\\s+as\\s+varchar\\s*\\)","to_char($2)")   //cast(12_2a33 as varchar)
                .replaceAll("(cast|CAST)\\s*\\(\\s*(['a-zA-Z0-9_]+\\.)\\s+as\\s+varchar\\s*\\(\\s*\\d+\\s*\\)?\\s*\\)","to_char($2)")   // cast  ( xx123123_x  as  varchar(123) )
                .replaceAll("(cast|CAST)\\s*\\(\\s*(['a-zA-Z0-9_]+\\.)\\s+as\\s+numeric\\s*\\(\\s*\\d+\\s*,\\s*\\d+\\s*\\)\\s*\\)","to_number($2)") // cast(x123_xx  as  numeric(123,2) )
                .replaceAll("(cast|CAST)\\s*\\(\\s*(['a-zA-Z0-9_]+\\.)\\s+as\\s+(datetime|DATE|date|DATETIME)\\s*\\)","to_date($2)")  //cast (xx123123_x as DATETIME )
                .replaceAll("([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)","to_date($1,'yyyy-mm-dd hh24:mi:ss')")  // 2021-01-22 00:00:00
                .replaceAll("([^\\s^>^<^=]+)(\\s*(>=|=|<=|>|<)\\s*(to_date|TO_DATE)\\((\\s*['0-9a-zA-Z_\\-\\s:\\.]+\\s*))(\\))"," to_date($1,'yyyy-mm-dd hh24:mi:ss') $2,'yyyy-mm-dd hh24:mi:ss'$6")
                .replaceAll("((to_date|TO_DATE)\\(\\s*['0-9a-zA-Z_\\-\\s:\\.]+\\s*)(\\))(\\s*(>=|=|<=|>|<)\\s?)([^\\s^>^<^=]+)"," $1,'yyyy-mm-dd hh24:mi:ss'$3 $4 to_date($6,'yyyy-mm-dd hh24:mi:ss')")
                .replaceAll("(with\\(nolock\\)|WITH\\(NOLOCK\\))","")

        ;
        return sql;
    }




}
