/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.io.File;
import java.util.Objects;

public final class SitePathInfo {
    private static SitePathInfo instance;
    private String rootPhysicalPath;
    private String contextPath;
    private String tomcatAppsPath;

    public static SitePathInfo getInstance() {
        if (instance == null) {
            instance = new SitePathInfo();
        }
        return instance;
    }

    private SitePathInfo() {
        String claPath = Objects.requireNonNull(SitePathInfo.class.getClassLoader().getResource("")).getPath();
        claPath = claPath.replaceAll("%20", " ");
        int rootDestIndex = claPath.lastIndexOf("/WEB-INF/");
        if (rootDestIndex <= 0) {
            rootDestIndex = claPath.lastIndexOf("/bin/");
        }
        if (rootDestIndex <= 0) {
            rootDestIndex = claPath.lastIndexOf("/");
        }
        String root = claPath.substring(1, rootDestIndex);
        this.rootPhysicalPath = root + "/";
        this.contextPath = root.substring(root.lastIndexOf("/"));
        this.tomcatAppsPath = root.substring(0, root.lastIndexOf("/"));
    }

    public String getRootPhysicalPath() {
        return this.rootPhysicalPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getTomcatAppsPath() {
        return this.tomcatAppsPath;
    }

    public String getWebInfPath() {
        return this.getVerifiedPath(this.getRootPhysicalPath() + "WEB-INF/");
    }

    public String getWebDataPath() {
        return this.getVerifiedPath(this.getRootPhysicalPath() + "WEB-INF/data/");
    }

    public String getVerifiedPath(String path) {
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }
}

