package com.aote.manager;

import org.dom4j.*;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.InputStream;
import java.util.Iterator;

public class DatabaseServer {
	public JSONArray getDatabases() {
		JSONArray result = new JSONArray();
		
		SAXReader reader = new SAXReader();
		InputStream input = DatabaseServer.class.getClassLoader().getResourceAsStream("hibernate.cfg.xml");
		try {
			// 到session-factory节点
			Document document = reader.read(input);
			Element root = document.getRootElement();
			root = root.element("session-factory");
			
			// 保存找到的最近的未匹配内容的注释
			JSONObject item = null;
			
			// 对于session-factory的每一个子节点
			for (Iterator it = root.nodeIterator(); it.hasNext();) {
				Node node = (Node) it.next();
				// 如果是注释，对注释进行处理
				if (node instanceof Comment) {
					Comment comment = (Comment)node;
					item = this.getDatabase(comment);
				} 
				// 是节点，对节点进行处理
				else if (node instanceof Element) {
					Element element = (Element)node;
					if ("mapping".equals(element.getName())) {
						// 如果没有注释，产生空注释
						if (item == null) {
							item = new JSONObject();
							item.put("summery", "");
						}
						this.procElement(element, item);
						result.put(item);
						item = null;
					}
				}
			}
			
			return result;
		} catch (DocumentException ex) {
			throw new RuntimeException(ex);
		}
	}
	
	// 对注释进行处理，从注释中获取说明
	private JSONObject getDatabase(Comment comment) {
		String text = comment.getText();
		JSONObject json = new JSONObject();
		json.put("summery", text);
		return json;
	}
	
	// 对找到的节点进行处理, 返回数据库的内容, 包括路径、关键字段等
	private void procElement(Element element, JSONObject item) {
		String result = element.attributeValue("resource");
		item.put("text", "路径: " + result);
		this.procFile(result, item);
	}
	
	// 根据给定路径打开数据库mapping文件，找到名称等内容
	private void procFile(String path, JSONObject item) {
		SAXReader reader = new SAXReader();
		InputStream input = DatabaseServer.class.getClassLoader().getResourceAsStream(path);
		try {
			Document document = reader.read(input);
			Element root = document.getRootElement();
			root = root.element("class");
			item.put("name", root.attributeValue("entity-name"));
		} catch (DocumentException ex) {
			throw new RuntimeException(ex);
		}
	}
}
