package com.aote.util;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class XMLReaderUtil {

	private static Logger log = Logger.getLogger(XMLReaderUtil.class);

	private String[] fields;

	private static String inputStream2String(InputStream is) throws IOException {

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		int i;
		while ((i = is.read()) != -1) {
			baos.write(i);
		}
		return baos.toString();
	}

	public XMLConfiguration getConfig(String xmlName) {
		XMLConfiguration config = new XMLConfiguration();
		InputStream is = null;
		try {
			InputStream input = this.getClass().getResourceAsStream(
					"/" + xmlName);
			String s = inputStream2String(input);
			String dtd = "<!DOCTYPE"
					+ StringUtils.substringBetween(s, "<!DOCTYPE", ".dtd\">")
					+ ".dtd\">";
			String s1 = s.replaceAll(dtd, "");
			is = new ByteArrayInputStream(s1.getBytes());
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		config.setSchemaValidation(false);
		config.setDelimiterParsingDisabled(true);
		config.setValidating(false);
		try {
			config.load(is);
		} catch (ConfigurationException e) {
			e.printStackTrace();
		}
		config.setSchemaValidation(false);
		config.setDelimiterParsingDisabled(true);
		config.setValidating(false);
		return config;
	}

	/**
	 * 根据xmlName获取hbm.xml文件中property所对应的中文commont
	 *
	 */
	public LinkedHashMap<Object, Object> getCommont(String xmlName) {
		// JSONObject jo = new JSONObject();
		XMLConfiguration config = getConfig(xmlName);
		List<Object> name = config.getList("class.property.column[@name]");
		List<Object> name1 = config.getList("class.many-to-one.column[@name]");
		if (name1.size() > 0) {
			name.addAll(name1);
		}
		List<Object> name3 = config.getList("class.set[@name]");
		if (name3.size() > 0) {
			for (Object aName3 : name3) {
				// 若有一对一关系，将关联的表字段转为json对象存入
				JSONObject json = new JSONObject();
				// 将name转成映射文件后缀的名字
				json.put((String) aName3, this.getConfigPath(
						aName3 + ".hbm.xml", null));
				System.out.println(json.toString());
				name.add(json);
			}
		}
		List<Object> name2 = config.getList("class.one-to-one[@name]");
		if (name2.size() > 0) {
			for (Object aName2 : name2) {
				// 若有一对一关系，将关联的表字段转为json对象存入
				JSONObject json = new JSONObject();
				// 通过名字找到映射文件
				json.put((String) aName2, this.getConfigPath(
						aName2 + ".hbm.xml", null));
				System.out.println(json.toString());
				name.add(json);
			}
		}
		List<Object> comment = config.getList("class.property.column.comment");
		// List<Object> comment1 = config
		// .getList("class.many-to-one.column.comment");
		// if (comment1.size() > 0) {
		// for (int i = 0; i < name1.size(); i++) {
		// comment.add(comment1.get(i));
		// }
		// }
		// List<Object> comment2 = config
		// .getList("class.one-to-one.comment");
		// if (comment2.size() > 0) {
		// for (int i = 0; i < name2.size(); i++) {
		// comment.add(comment2.get(i));
		// }
		// }
		// List<Object> comment3 = config
		// .getList("class.one-to-many.column.comment");
		// if (comment3.size() > 0) {
		// for (int i = 0; i < name3.size(); i++) {
		// comment.add(comment3.get(i));
		// }
		// }

		// List<?> comment = config.getList("class.property.column.comment");
		// if (name.size() == comment.size()) {
		// for (int i = 0; i < name.size(); i++) {
		// jo.put((String) name.get(i), comment.get(i));
		// }
		// }
		LinkedHashMap<Object, Object> map = new LinkedHashMap<>();
		for (int i = 0; i < name.size(); i++) {
			if (name.get(i) instanceof JSONObject) {
				// 这个value值没用
				map.put(name.get(i), "json对象");
			} else {
				map.put(name.get(i), comment.get(i));
			}
		}
		log.debug("getCommont返回: " + map.toString());
		return map;

	}

	/**
	 * 通过hibernate找到对应的config路径
	 *
	 * @param xmlName
	 *            hibernate映射文件的相对路径 ('hibernate/../***.hbm.xml')
	 * @param newPath
	 *            在查找子映射文件时，若和父映射文件不在同一目录下，传入新路径
	 * @return 返回子映射文件文本对应的字段数组
	 */
	public Object[] getConfigPath(String xmlName, String newPath) {
		Object[] result = null;
		// 获取程序当前路径
		if (newPath == null) {
			newPath = this.getCurrentPath() + "hibernate";
		}
		File files = new File(newPath);

		File[] file = files.listFiles();

		if (file != null) {
			for (File aFile : file) {
				if (aFile.isFile()) {
					if (xmlName.equals(aFile.getName())) {
						// 对路径进行处理（只取hibernate之后的路径）
						String[] split = aFile.getPath().split("hibernate");
						result = this.getColumn(
								("hibernate" + split[split.length - 1]).replace(
										"\\", "/"), this.fields);
					}
				} else if (aFile.isDirectory()) {
					result = this.getConfigPath(xmlName, aFile.getPath());
					// 如果接下来还有关联关系这个result会被覆盖掉
					if (result != null) {
						break;
					}
				}
			}
		}
		return result;
	}

	/**
	 * 获取当前路径
	 */
	private String getCurrentPath() {
		String rootpath = this.getClass().getResource("/").toString();
		return rootpath.substring(5);
	}

	/**
	 * 根据传入的hibernate配置路径查找汉字对应的列名
	 *
	 * @param xmlName
	 *            配置文件的全路径名
	 * @param fields
	 *            模板表头汉字数组
	 * @return 返回传入汉字对应的字段数组，顺序不变
	 */
	public Object[] getColumn(String xmlName, String[] fields) {
		this.fields = fields;

		// 涉及到增加数据用集合操作
		List<Object> list = new ArrayList<>();
		// for(String str : fields){
		// list.add(str);
		// }

		LinkedHashMap<Object, Object> map = getCommont(xmlName);
		for (Object key : map.keySet()) {
			String value = (String) map.get(key);
			for (String field : fields) {
				// replaceAll去掉字符串之间的空格 trim()不能去掉两个汉字之间的空格
				if (field.replaceAll(" ", "").equals(value.replaceAll(" ", ""))) {
					list.add(key);
				}
			}

			if (key instanceof JSONObject) {
				list.add(key);
			}
		}
		System.out.println(Arrays.toString(list.toArray()));
		return list.toArray();
	}

}
