package com.aote.rs;

import com.af.plugins.AESUtil;
import com.aote.exception.ExceptionLogManage;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

/**
 * 提供sql查询服务
 */
@Path("sql")
@Component
@Transactional
public class SqlService {
	static Logger log = Logger.getLogger(SqlService.class);

	@Autowired
	private SqlServer sqlServer;

	@Autowired
	private ExceptionLogManage exceptionLogManage;

	/**
	 * 获取SQL语句的合计执行结果
	 *
	 * @param name
	 *            : sql语句名
	 * @param str
	 *            : sql语句执行参数
	 */
	@POST
	@Path("{name}/n")
	public String txgetTotalCnt(@PathParam("name") String name, String str)
			throws Exception {
		try {
			return sqlEncrypt(name, str, 1);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/"+name+"/n");
			throw ex;
		}
	}

	/**
	 * 执行sql,对sql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("{name}")
	public String txExecute(@PathParam("name") String name,
							@QueryParam("pageNo") int pageNo,
							@QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			return sqlEncrypt(name, str, 2, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/"+name);
			throw ex;
		}
	}

	/**
	 * 获取HQL语句的合计执行结果
	 *
	 * @param name
	 *            : hql语句名
	 * @param str
	 *            : hql语句执行参数
	 */
	@POST
	@Path("hql/{name}/n")
	public String txHqlgetTotalCnt(@PathParam("name") String name, String str)
			throws Exception {
		try {
			return sqlEncrypt(name, str, 3);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/hql/"+name+"/n");
			throw ex;
		}
	}

	/**
	 * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("hql/{name}")
	public String txHqlExecute(@PathParam("name") String name,
							   @QueryParam("pageNo") int pageNo,
							   @QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			return sqlEncrypt(name, str, 4, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/hql/"+name);
			throw ex;
		}
	}

	/**
	 * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 * 取消大于1000时限制1000的条件
	 */
	@POST
	@Path("hql/{name}/all")
	public String txHqlExecuteAll(@PathParam("name") String name,
								  @QueryParam("pageNo") int pageNo,
								  @QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			return sqlEncrypt(name, str, 5, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/hql/"+name+"/all");
			throw ex;
		}
	}

	/**
	 * 封装sql加解密
	 * @param sqlName sql名
	 * @param param	参数
	 * @param method 区分调用
	 * @param value	接收分页的两个参数
	 * @return
	 */
	private String sqlEncrypt(String sqlName, String param, int method, int ... value)throws Exception{
		JSONObject paramJson = new JSONObject(param);
		JSONObject configJson = JsonHelper.getConfig();
		//验证
		Util.checkEncry(paramJson, configJson);
		//如果不需要加密，进入default正常执行
		if (!paramJson.has("aoteEncrypt")){
			paramJson.put("aoteEncrypt", "default");
		}
		//sql注入标志位
		boolean sqlInject=false;
		if(configJson.has("sqlInject")){
			sqlInject = configJson.getBoolean("sqlInject");
		}
		//判断解密方式
		switch (paramJson.getString("aoteEncrypt")){
			case "AES" :
				// 数据解密
				String encryKey = configJson.getString("encryKey");
				String data = paramJson.getString("data");
				String decryData = AESUtil.decrypt(data, encryKey);
				// 验证参数是否合法
				if(sqlInject) {
					ParamFilter.checkSqlJsonStr(decryData);
				}
				if (method == 1){
					return AESUtil.encrypt(sqlServer.queryTotal(sqlName, decryData).toString(), encryKey);
				}else if (method == 2){
					return AESUtil.encrypt(sqlServer.query(sqlName, value[0], value[1], decryData).toString(), encryKey);
				}else if (method == 3){
					return AESUtil.encrypt(sqlServer.queryHqlTotal(sqlName, decryData).toString(), encryKey);
				}else if (method == 4){
					return AESUtil.encrypt(sqlServer.hqlQuery(sqlName, value[0], value[1], decryData).toString(), encryKey);
				}else{
					return AESUtil.encrypt(sqlServer.hqlQueryAll(sqlName, value[0], value[1], decryData).toString(), encryKey);
				}
			default:
				// 验证参数是否合法
				if(sqlInject) {
					ParamFilter.checkSqlJsonStr(param);
				}
				if (method == 1){
					return sqlServer.queryTotal(sqlName, param).toString();
				}else if (method == 2){
					return sqlServer.query(sqlName, value[0], value[1], param).toString();
				}else if (method == 3){
					return sqlServer.queryHqlTotal(sqlName, param).toString();
				}else if (method == 4){
					return sqlServer.hqlQuery(sqlName, value[0], value[1], param).toString();
				}else{
					return sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString();
				}
		}
	}
}
