/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class XMLReaderUtil {
    private static Logger log = Logger.getLogger(XMLReaderUtil.class);
    private String[] fields;

    private static String inputStream2String(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        return baos.toString();
    }

    public XMLConfiguration getConfig(String xmlName) {
        XMLConfiguration config = new XMLConfiguration();
        ByteArrayInputStream is = null;
        try {
            InputStream input = this.getClass().getResourceAsStream("/" + xmlName);
            String s = XMLReaderUtil.inputStream2String(input);
            String dtd = "<!DOCTYPE" + StringUtils.substringBetween((String)s, (String)"<!DOCTYPE", (String)".dtd\">") + ".dtd\">";
            String s1 = s.replaceAll(dtd, "");
            is = new ByteArrayInputStream(s1.getBytes());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        config.setSchemaValidation(false);
        config.setDelimiterParsingDisabled(true);
        config.setValidating(false);
        try {
            config.load(is);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        config.setSchemaValidation(false);
        config.setDelimiterParsingDisabled(true);
        config.setValidating(false);
        return config;
    }

    public LinkedHashMap<Object, Object> getCommont(String xmlName) {
        List name2;
        List name3;
        XMLConfiguration config = this.getConfig(xmlName);
        List name = config.getList("class.property.column[@name]");
        List name1 = config.getList("class.many-to-one.column[@name]");
        if (name1.size() > 0) {
            name.addAll(name1);
        }
        if ((name3 = config.getList("class.set[@name]")).size() > 0) {
            for (Object aName3 : name3) {
                JSONObject json = new JSONObject();
                json.put((String)aName3, (Object)this.getConfigPath(aName3 + ".hbm.xml", null));
                System.out.println(json.toString());
                name.add(json);
            }
        }
        if ((name2 = config.getList("class.one-to-one[@name]")).size() > 0) {
            for (Object aName2 : name2) {
                JSONObject json = new JSONObject();
                json.put((String)aName2, (Object)this.getConfigPath(aName2 + ".hbm.xml", null));
                System.out.println(json.toString());
                name.add(json);
            }
        }
        List comment = config.getList("class.property.column.comment");
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < name.size(); ++i) {
            if (name.get(i) instanceof JSONObject) {
                map.put(name.get(i), "json\u5bf9\u8c61");
                continue;
            }
            map.put(name.get(i), comment.get(i));
        }
        log.debug((Object)("getCommont\u8fd4\u56de: " + map.toString()));
        return map;
    }

    public Object[] getConfigPath(String xmlName, String newPath) {
        File files;
        File[] file;
        Object[] result = null;
        if (newPath == null) {
            newPath = this.getCurrentPath() + "hibernate";
        }
        if ((file = (files = new File(newPath)).listFiles()) != null) {
            for (File aFile : file) {
                if (aFile.isFile()) {
                    if (!xmlName.equals(aFile.getName())) continue;
                    String[] split = aFile.getPath().split("hibernate");
                    result = this.getColumn(("hibernate" + split[split.length - 1]).replace("\\", "/"), this.fields);
                    continue;
                }
                if (aFile.isDirectory() && (result = this.getConfigPath(xmlName, aFile.getPath())) != null) break;
            }
        }
        return result;
    }

    private String getCurrentPath() {
        String rootpath = this.getClass().getResource("/").toString();
        return rootpath.substring(5);
    }

    public Object[] getColumn(String xmlName, String[] fields) {
        this.fields = fields;
        ArrayList<Object> list = new ArrayList<Object>();
        LinkedHashMap<Object, Object> map = this.getCommont(xmlName);
        for (Object key : map.keySet()) {
            String value = (String)map.get(key);
            for (String field : fields) {
                if (!field.replaceAll(" ", "").equals(value.replaceAll(" ", ""))) continue;
                list.add(key);
            }
            if (!(key instanceof JSONObject)) continue;
            list.add(key);
        }
        System.out.println(Arrays.toString(list.toArray()));
        return list.toArray();
    }
}

