/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.af.plugins.AESUtil;
import com.aote.exception.ExceptionLogManage;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="sql")
@Component
@Transactional
public class SqlService {
    static Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private ExceptionLogManage exceptionLogManage;

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 1, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name + "/n");
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 2, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 3, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name + "/n");
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}")
    public String txHqlExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 4, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/all")
    public String txHqlExecuteAll(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 5, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name + "/all");
            throw ex;
        }
    }

    private String sqlEncrypt(String sqlName, String param, int method, int ... value) throws Exception {
        JSONObject paramJson = new JSONObject(param);
        JSONObject configJson = JsonHelper.getConfig();
        Util.checkEncry(paramJson, configJson);
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        boolean sqlInject = false;
        if (configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        switch (paramJson.getString("aoteEncrypt")) {
            case "AES": {
                String encryKey = configJson.getString("encryKey");
                String data = paramJson.getString("data");
                String decryData = AESUtil.decrypt((String)data, (String)encryKey);
                if (sqlInject) {
                    ParamFilter.checkSqlJsonStr(decryData);
                }
                if (method == 1) {
                    return AESUtil.encrypt((String)this.sqlServer.queryTotal(sqlName, decryData).toString(), (String)encryKey);
                }
                if (method == 2) {
                    return AESUtil.encrypt((String)this.sqlServer.query(sqlName, value[0], value[1], decryData).toString(), (String)encryKey);
                }
                if (method == 3) {
                    return AESUtil.encrypt((String)this.sqlServer.queryHqlTotal(sqlName, decryData).toString(), (String)encryKey);
                }
                if (method == 4) {
                    return AESUtil.encrypt((String)this.sqlServer.hqlQuery(sqlName, value[0], value[1], decryData).toString(), (String)encryKey);
                }
                return AESUtil.encrypt((String)this.sqlServer.hqlQueryAll(sqlName, value[0], value[1], decryData).toString(), (String)encryKey);
            }
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(param);
        }
        if (method == 1) {
            return this.sqlServer.queryTotal(sqlName, param).toString();
        }
        if (method == 2) {
            return this.sqlServer.query(sqlName, value[0], value[1], param).toString();
        }
        if (method == 3) {
            return this.sqlServer.queryHqlTotal(sqlName, param).toString();
        }
        if (method == 4) {
            return this.sqlServer.hqlQuery(sqlName, value[0], value[1], param).toString();
        }
        return this.sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString();
    }
}

