/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.util.ResourceHelper;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonHelper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T toParse(JSONObject json, Class<T> obj) {
        Object t = null;
        try {
            t = objectMapper.readValue(json.toString(), obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> List<T> toParseList(JSONArray json, Class<T> obj) {
        List t = null;
        try {
            t = (List)objectMapper.readValue(json.toString(), JsonHelper.getCollectionType(List.class, obj));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    public static <T> JSONArray toJsonArray(List<T> entity) {
        try {
            return new JSONArray(objectMapper.writeValueAsString(entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject toJSON(Object entity) {
        try {
            return new JSONObject(objectMapper.writeValueAsString(entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static Map<String, Object> toMap(JSONObject object) {
        return object.toMap();
    }

    public static JSONObject getConfig() {
        if (ResourceHelper.class.getResourceAsStream("/config.json") == null) {
            return null;
        }
        try {
            return new JSONObject(ResourceHelper.getString("config.json"));
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6config\u5f02\u5e38", e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

