/*
 * Decompiled with CFR 0.152.
 */
package com.aote.transaction;

import com.aote.ThreadResource;
import com.aote.transaction.ThreadSession;
import javassist.NotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionPool {
    @Autowired
    private SessionFactory factory;
    @Autowired
    private ThreadSession tSession;
    private InnerSession[] sessions = new InnerSession[100];
    private static SessionPool instance;

    public static SessionPool getInstance() {
        return instance;
    }

    private SessionPool() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createSession() throws NotFoundException {
        Session session = this.factory.openSession();
        Transaction trans = session.beginTransaction();
        InnerSession innerSession = new InnerSession(this, session, trans);
        InnerSession[] innerSessionArray = this.sessions;
        synchronized (this.sessions) {
            for (int i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] != null) continue;
                this.sessions[i] = innerSession;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            throw new NotFoundException("\u6ca1\u6709\u7a7a\u95f2\u4f4d\u7f6e");
        }
    }

    public Session getSession(int i) {
        return this.sessions[i].session;
    }

    public Session getSession() {
        Session threadSession = this.tSession.get();
        if (threadSession != null) {
            return threadSession;
        }
        Integer sessionId = ThreadResource.SessionId.get();
        if (sessionId != null) {
            int i = sessionId;
            return this.getSession(i);
        }
        return this.factory.getCurrentSession();
    }

    private class InnerSession {
        public Session session;
        public Transaction transaction;

        public InnerSession(SessionPool sessionPool, Session session, Transaction transaction) {
            this.session = session;
            this.transaction = transaction;
        }
    }
}

