/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.af.plugins.ConvertTools;
import com.aote.exception.ExceptionLogManage;
import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.mq.RocketMQProducer;
import com.aote.redis.RedisUtil;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SnowflakeIdWorker;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    static Logger reviewLog = Logger.getLogger((String)"reviewLog");
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private RocketMQProducer producer;
    @Autowired
    private ResourceHelper resourceHelper;
    @Autowired
    private ExceptionLogManage exceptionLogManage;
    public static final ThreadLocal<String> reviewKey = new ThreadLocal();
    public static final Map<String, JSONArray> reviewCache = new ConcurrentHashMap<String, JSONArray>();

    @GET
    @Path(value="/clear")
    public String clearLogicCache() {
        ResourceHelper.clearLogicCache();
        return "ok";
    }

    @GET
    @Path(value="/clearall")
    public String clearAllCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        return "ok";
    }

    @GET
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        String requestParams = this.getRequestParams(null, request);
        String requestId = request.getHeader("X-Request-ID");
        return this.runMain(logicName, requestParams, requestId);
    }

    @POST
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        String requestParams = this.getRequestParams(values, request);
        String requestId = null;
        if (request != null) {
            requestId = request.getHeader("X-Request-ID");
        }
        return this.runMain(logicName, requestParams, requestId);
    }

    @GET
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        String values = params.toString();
        return this.runMQ(logicName, values);
    }

    @POST
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        String requestParams = this.getRequestParams(values, request);
        return this.runMQ(logicName, requestParams);
    }

    @GET
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        try {
            this.logicServer.runAsync(logicName, params.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (params.has("msg")) {
            return Response.ok((Object)params.getJSONArray("msg").get(0)).build();
        }
        return Response.ok((Object)new JSONObject().put("returnCode", (Object)"0000").toString()).build();
    }

    @POST
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        try {
            this.logicServer.runAsync(logicName, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok((Object)new JSONObject().put("returnCode", (Object)"0000").toString()).build();
    }

    public String xtSave(String logicName, String values) {
        return this.xtSave(logicName, values, null).getEntity().toString();
    }

    private Response runMain(String logicName, String values, String requestId) {
        String id = requestId != null ? requestId : SnowflakeIdWorker.getValue().toString();
        reviewKey.set(id);
        long begin = System.currentTimeMillis();
        JSONObject reviewObj = new JSONObject();
        reviewObj.put("requestId", (Object)id);
        reviewCache.put(id, new JSONArray());
        RedisUtil redisUtil = RedisUtil.getInstance();
        try {
            reviewObj.put("status", 0);
            boolean isEnableCache = LogicMapper.isEnableCache(logicName);
            if (!isEnableCache) {
                Object result = this.logicServer.run(logicName, values);
                Response response = this.buildResponse(result);
                return response;
            }
            String cacheKeyValue = LogicMapper.getCacheKey(logicName);
            if (!values.startsWith("{")) {
                log.warn((Object)("Logic[" + logicName + "]\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u6ee1\u8db3\u83b7\u53d6\u81ea\u5b9a\u4e49\u7f13\u5b58Key\uff0c\u5df2\u8df3\u8fc7\u83b7\u53d6\u7f13\u5b58"));
                Object result = this.logicServer.run(logicName, values);
                Response response = this.buildResponse(result);
                return response;
            }
            JSONObject params = new JSONObject(values);
            String paramsStr = Optional.ofNullable(cacheKeyValue).isPresent() && params.has(cacheKeyValue) ? params.get(cacheKeyValue).toString() : ConvertTools.base64Encode((byte[])new TreeMap(params.toMap()).toString().getBytes(StandardCharsets.UTF_8));
            String cacheKey = "LogicDataCache@" + logicName + "-" + paramsStr;
            Object cacheResult = redisUtil.get(cacheKey);
            if (cacheResult != null) {
                log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:Logic[" + logicName + "]\u547d\u4e2d\u7f13\u5b58\uff0c\u53c2\u6570\uff1a" + values));
                Response response = this.buildResponse(cacheResult.toString());
                return response;
            }
            long cacheTime = LogicMapper.getCacheTime(logicName);
            Object result = redisUtil.lock(cacheKey, (Integer)(cacheTime <= 0L ? 0 : 60), (Integer)300, () -> {
                if (cacheTime <= 0L) {
                    return this.logicServer.run(logicName, values);
                }
                Object newCacheResult = redisUtil.get(cacheKey);
                if (newCacheResult != null) {
                    log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:Logic[" + logicName + "]\u547d\u4e2d\u7f13\u5b58\uff0c\u53c2\u6570\uff1a" + values));
                    return newCacheResult;
                }
                newCacheResult = this.logicServer.run(logicName, values);
                if (newCacheResult != null) {
                    redisUtil.set(cacheKey, newCacheResult, cacheTime);
                    log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:Logic[" + logicName + "]\u7f13\u5b58\u6210\u529f\uff0c\u5b58\u6d3b\u65f6\u95f4\uff1a" + cacheTime + "\u79d2"));
                }
                return newCacheResult;
            });
            Response response = this.buildResponse(result.toString());
            return response;
        }
        catch (Exception e) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(e), 1);
            log.error((Object)stack);
            String path = LogicMapper.getLogic(logicName);
            if (path == null) {
                path = logicName;
            }
            this.exceptionLogManage.writeError(e, path, "/rs/logic/" + logicName, values);
            reviewObj.put("status", -1);
            WebException wex = this.getWebException(e);
            if (wex != null) {
                throw wex;
            }
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            reviewObj.put("bTime", begin);
            reviewObj.put("eTime", end);
            reviewObj.put("constTime", end - begin);
            reviewObj.put("type", (Object)"logic");
            reviewObj.put("items", (Object)reviewCache.get(id));
            reviewLog.debug((Object)reviewObj);
            reviewKey.remove();
            reviewCache.remove(id);
        }
    }

    private Response runMQ(String logicName, String values) throws RemotingException, InterruptedException, MQClientException {
        JSONObject params;
        Message msg = new Message("logic", logicName, values.getBytes(StandardCharsets.UTF_8));
        this.producer.getDefaultMQProducer().sendOneway(msg);
        if (values.startsWith("{") && (params = new JSONObject(values)).has("msg")) {
            return Response.ok((Object)params.getJSONArray("msg").get(0)).build();
        }
        return Response.ok().build();
    }

    private Response buildResponse(Object metaResult) {
        String result = metaResult == null ? "" : (metaResult instanceof Map ? new JSONObject((Map)metaResult).toString() : (metaResult instanceof Collection ? new JSONArray((Collection)metaResult).toString() : metaResult.toString()));
        Response.ResponseBuilder builder = Response.ok();
        if (result.startsWith("{")) {
            JSONObject paramJson = new JSONObject(result);
            if (paramJson.has("header") && paramJson.has("content")) {
                Map paramHeader = paramJson.getJSONObject("header").toMap();
                for (Map.Entry stringObjectEntry : paramHeader.entrySet()) {
                    builder.header((String)stringObjectEntry.getKey(), (Object)String.valueOf(stringObjectEntry.getValue()));
                }
                return builder.type("text/plain").entity((Object)String.valueOf(paramJson.get("content"))).build();
            }
            builder.type(MediaType.APPLICATION_JSON_TYPE);
        }
        return builder.entity((Object)result).build();
    }

    @PostConstruct
    public void redisCacheLogic() {
        this.logicServer.redisCacheLogic();
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }

    private String getRequestParams(String values, HttpServletRequest request) {
        JSONObject paramsJson;
        if (StringUtils.isEmpty((Object)values)) {
            paramsJson = new JSONObject();
        } else if (values.startsWith("{") && values.endsWith("}")) {
            paramsJson = new JSONObject(values);
        } else {
            paramsJson = new JSONObject();
            paramsJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = (String)headerNames.nextElement();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramsJson.put("header", (Object)header);
            }
        }
        if (request != null) {
            Map parameterMap = request.getParameterMap();
            parameterMap.forEach((key, value) -> {
                if (((String[])value).length > 0 && !paramsJson.has(key)) {
                    paramsJson.put(key, (Object)value[0]);
                }
            });
        }
        return paramsJson.toString();
    }
}

