/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import cn.hutool.core.date.DateUtil;
import com.aote.util.ClobUtil;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

public class StandardAliasTransformer
extends AliasedTupleSubsetResultTransformer {
    private static final Logger logManager = LogManager.getLogger(StandardAliasTransformer.class);
    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    private StandardAliasTransformer() {
    }

    protected static void runTrans(Object obj, Object[] tuple, String[] aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias == null) continue;
            if (value instanceof BigDecimal) {
                BigDecimal valueObj = (BigDecimal)value;
                if (StandardAliasTransformer.isIntegerValue(valueObj)) {
                    long longValue = valueObj.longValue();
                    value = longValue < Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue;
                }
            } else if (value instanceof Date) {
                Date dateObj = (Date)value;
                value = DateUtil.formatDateTime((Date)dateObj);
            } else if (value instanceof Clob) {
                Clob clobObj = (Clob)value;
                value = ClobUtil.getClobString(clobObj);
            }
            if (obj instanceof JSONObject) {
                JSONObject object = (JSONObject)obj;
                object.put(alias.toLowerCase(), value);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map objectMap = (Map)obj;
            objectMap.put(alias.toLowerCase(), value);
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    public Map<String, Object> transformTuple(Object[] tuple, String[] aliases) {
        LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>(aliases.length);
        StandardAliasTransformer.runTrans(objectMap, tuple, aliases);
        return objectMap;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

