/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.exception.ExceptionLogManage;
import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.mq.RocketMQProducer;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SnowflakeIdWorker;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    static Logger reviewLog = Logger.getLogger((String)"reviewLog");
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private RocketMQProducer producer;
    @Autowired
    private ResourceHelper resourceHelper;
    @Autowired
    private ExceptionLogManage exceptionLogManage;
    public static final ThreadLocal<Long> reviewKey = new ThreadLocal();
    public static final Map<Long, JSONArray> reviewCache = new ConcurrentHashMap<Long, JSONArray>();

    @GET
    @Path(value="/clear")
    public String clearLogicCache() {
        ResourceHelper.clearLogicCache();
        return "ok";
    }

    @GET
    @Path(value="/clearall")
    public String clearAllCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        return "ok";
    }

    @GET
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        String values = params.toString();
        return this.runMain(logicName, values);
    }

    @POST
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            JSONObject header = new JSONObject();
            while (headerNames.hasMoreElements()) {
                String temp = (String)headerNames.nextElement();
                header.put(temp, (Object)request.getHeader(temp));
            }
            log.warn((Object)("\u5f97\u5230\u8bf7\u6c42\u5934\uff1a" + header));
        }
        values = this.getValues(values, request);
        return this.runMain(logicName, values);
    }

    @GET
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        String values = params.toString();
        return this.runMQ(logicName, values);
    }

    @POST
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        values = this.getValues(values, request);
        return this.runMQ(logicName, values);
    }

    @GET
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        try {
            this.runAsync(logicName, params.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (params.has("msg")) {
            return Response.ok((Object)params.getJSONArray("msg").get(0)).build();
        }
        return Response.ok((Object)new JSONObject().put("returnCode", (Object)"0000").toString()).build();
    }

    @POST
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        try {
            this.runAsync(logicName, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok((Object)new JSONObject().put("returnCode", (Object)"0000").toString()).build();
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = (String)headerNames.nextElement();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    public String xtSave(String logicName, String values) {
        return this.xtSave(logicName, values, null).getEntity().toString();
    }

    private Response runMain(String logicName, String values) {
        long id = SnowflakeIdWorker.getValue();
        reviewKey.set(id);
        long begin = System.currentTimeMillis();
        JSONObject reviewObj = new JSONObject();
        reviewCache.put(id, new JSONArray());
        try {
            JSONObject paramJson;
            String result = this.logicServer.runMain(logicName, values);
            Response.ResponseBuilder builder = Response.ok();
            if (result.startsWith("{") && (paramJson = new JSONObject(result)).has("header") && paramJson.has("content")) {
                Map paramHeader = paramJson.getJSONObject("header").toMap();
                for (Map.Entry stringObjectEntry : paramHeader.entrySet()) {
                    builder.header((String)stringObjectEntry.getKey(), (Object)String.valueOf(stringObjectEntry.getValue()));
                }
                Response response = builder.type("text/plain").entity((Object)String.valueOf(paramJson.get("content"))).build();
                return response;
            }
            reviewObj.put("status", 0);
            paramJson = builder.entity((Object)result).build();
            return paramJson;
        }
        catch (Exception e) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(e), 1);
            log.error((Object)stack);
            String path = LogicMapper.getLogic(logicName);
            if (path == null) {
                path = logicName;
            }
            this.exceptionLogManage.writeError(e, path, "/rs/logic/" + logicName, values);
            reviewObj.put("status", -1);
            WebException wex = this.getWebException(e);
            if (wex != null) {
                throw wex;
            }
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            reviewObj.put("bTime", begin);
            reviewObj.put("eTime", end);
            reviewObj.put("constTime", end - begin);
            reviewObj.put("type", (Object)"logic");
            reviewObj.put("items", (Object)reviewCache.get(id));
            reviewLog.debug((Object)reviewObj);
            reviewKey.remove();
            reviewCache.remove(id);
        }
    }

    private Response runMQ(String logicName, String values) throws RemotingException, InterruptedException, MQClientException {
        JSONObject params;
        Message msg = new Message("logic", logicName, values.getBytes(StandardCharsets.UTF_8));
        this.producer.getDefaultMQProducer().sendOneway(msg);
        if (values.startsWith("{") && (params = new JSONObject(values)).has("msg")) {
            return Response.ok((Object)params.getJSONArray("msg").get(0)).build();
        }
        return Response.ok().build();
    }

    @PostConstruct
    public void redisCacheLogic() {
        this.logicServer.redisCacheLogic();
    }

    private void runAsync(String logicName, String values) {
        this.logicServer.runAsync(logicName, values);
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }
}

