/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import cn.hutool.core.util.NumberUtil;
import com.aote.ThreadResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LogicMapper {
    static Logger LOGGER = Logger.getLogger(LogicMapper.class);
    private static final long DEFAULT_CACHE_TIME = 10800L;
    private static Map<String, Map<String, String>> map;

    public static Map<String, Map<String, String>> getAllMap() {
        return map;
    }

    public static String getLogic(String alias) {
        if (map.containsKey(alias)) {
            String result = LogicMapper.getLogicByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static boolean isEnableCache(String alias) {
        if (map.containsKey(alias)) {
            String cache = map.get(alias).get("cache");
            return cache != null && cache.equals("true");
        }
        return false;
    }

    public static long getCacheTime(String alias) {
        if (map.containsKey(alias)) {
            String time = map.get(alias).get("time");
            long timeValue = time != null ? Long.parseLong(time) : 10800L;
            timeValue += (long)NumberUtil.generateRandomNumber((int)0, (int)((int)timeValue), (int)1)[0];
            return timeValue;
        }
        return -1L;
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getLogicByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/logics/" + alias + ".logic";
        if (LogicMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = LogicMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                LogicMapper.parseModule(module);
            }
            if ((input = LogicMapper.class.getClassLoader().getResourceAsStream("logic.xml")) != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator("logic");
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    LogicMapper.setLogicRes(element, null, null);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String path = elm.attributeValue("path");
            LogicMapper.putMap(name, reader, path);
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        String str = parent == null ? name + "/logic.xml" : parent + "/" + name + "/logic.xml";
        InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);
        if (moduleLogic == null) {
            throw new RuntimeException("\u6ce8\u610f\uff01\uff01\uff01\u6a21\u5757[" + name + "]\u627e\u4e0d\u5230logic\u6620\u5c04\u6587\u4ef6\uff1a" + str);
        }
        Document docLogic = reader.read(moduleLogic);
        Element rootLogic = docLogic.getRootElement();
        Iterator item = rootLogic.elementIterator("logic");
        while (item.hasNext()) {
            Element element = (Element)item.next();
            LogicMapper.setLogicRes(element, name, parent);
        }
    }

    private static void setLogicRes(Element element, String moduleName, String moduleParent) throws Exception {
        String aliasLogic = element.attribute("alias").getValue();
        String pathLogic = element.attribute("path").getValue();
        String log = element.attributeValue("log");
        String mobile = element.attributeValue("mobile");
        String cache = element.attributeValue("cache");
        String time = element.attributeValue("time");
        if (map.containsKey(aliasLogic)) {
            throw new Exception("Logic\u522b\u540d" + aliasLogic + "\u5df2\u5b58\u5728");
        }
        String path = (moduleParent == null ? moduleName + "/logics/" : moduleParent + "/" + moduleName + "/logics/") + pathLogic;
        HashMap<String, String> logic = new HashMap<String, String>();
        logic.put("alias", aliasLogic);
        logic.put("path", path);
        logic.put("log", log);
        logic.put("mobile", mobile);
        logic.put("cache", cache);
        logic.put("time", time);
        map.put(aliasLogic, logic);
    }

    static {
        LogicMapper.loadMap();
    }
}

