/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.util.ClobUtil;
import java.math.BigDecimal;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

public class AliasTransformer
extends AliasedTupleSubsetResultTransformer {
    public static final AliasTransformer INSTANCE = new AliasTransformer();

    private AliasTransformer() {
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> result = new HashMap<String, Object>(tuple.length);
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias == null) continue;
            Object value = tuple[i];
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof Date) {
                value = SIMPLE_DATE_FORMAT.format(value);
            } else if (value instanceof Clob) {
                value = ClobUtil.getClobString((Clob)value);
            } else if (value instanceof BigDecimal && AliasTransformer.isIntegerValue((BigDecimal)value)) {
                long longValue = ((BigDecimal)value).longValue();
                value = longValue < Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue;
            }
            result.put(alias.toLowerCase(), value);
        }
        return result;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

