/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.logic.SpringBeansPour;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlMapper;
import com.aote.util.ResourceHelper;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PluginMapper
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    static Logger log;
    private static Map<String, Object> map;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        applicationContext = ctx;
        map = PluginMapper.loadMap();
    }

    public static Map<String, Object> getPlugins() {
        return map;
    }

    private static Map<String, Object> loadMap() {
        Map<String, Object> result = PluginMapper.innerLoadMap("");
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        for (String key : map.keySet()) {
            Map<String, String> modules = map.get(key);
            Map<String, Object> plugins = modules.get("path") != null ? PluginMapper.innerLoadMap(modules.get("path"), key) : PluginMapper.innerLoadMap(key);
            result.putAll(plugins);
        }
        return result;
    }

    private static Map<String, Object> innerLoadMap(String module) {
        return PluginMapper.innerLoadMap("", module);
    }

    private static Map<String, Object> innerLoadMap(String path, String module) {
        Document document;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!"".equals(path)) {
            path = path + "/";
        }
        if (!"".equals(module)) {
            module = module + "/";
        }
        if (ResourceHelper.class.getResourceAsStream("/" + path + module + "plugins.xml") == null) {
            log.warn((Object)"\u65e0plugins.xml\u6587\u4ef6");
            return map;
        }
        SAXReader reader = new SAXReader();
        InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream(path + module + "plugins.xml");
        try {
            document = reader.read(input);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("plugin");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String alias = elm.attribute("alias").getValue();
            String className = elm.attribute("class").getValue();
            try {
                Object obj;
                Class<?> c = Class.forName(className);
                if (PluginMapper.isSpring(c)) {
                    obj = applicationContext.getBean(c);
                } else {
                    obj = c.newInstance();
                    if (obj instanceof SpringBeansPour) {
                        ((SpringBeansPour)obj).initBeans(applicationContext);
                    }
                }
                map.put(alias, obj);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)("\u672a\u627e\u5230\u7c7b, \u6a21\u5757=" + module + ", \u7c7b=" + ex.getMessage()));
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return map;
    }

    public static boolean isSpring(Class<?> c) {
        for (Annotation annotation : c.getAnnotations()) {
            if (annotation.annotationType() != Component.class) continue;
            return true;
        }
        return false;
    }

    public void main(String[] args) {
        PluginMapper.loadMap();
        for (String key : map.keySet()) {
            System.out.println(key);
        }
    }

    static {
        log = Logger.getLogger(PluginMapper.class);
        map = null;
    }
}

