/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.ThreadResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LogicMapper {
    static Logger log = Logger.getLogger(LogicMapper.class);
    private static Map<String, Map<String, String>> map;

    public static String getLogic(String alias) {
        if (map.containsKey(alias)) {
            String result = LogicMapper.getLogicByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getAttr(String alias, String name) {
        if (map.containsKey(alias)) {
            return map.get(alias).get(name);
        }
        return null;
    }

    public static String getLogicByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = dir + "/logics/" + alias + ".logic";
        if (LogicMapper.class.getClassLoader().getResourceAsStream(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = LogicMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                LogicMapper.parseModule(module);
            }
            if ((input = LogicMapper.class.getClassLoader().getResourceAsStream("logic.xml")) != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator("logic");
                while (it.hasNext()) {
                    Element elm = (Element)it.next();
                    HashMap<String, String> logic = new HashMap<String, String>();
                    String alias = elm.attribute("alias").getValue();
                    logic.put("alias", alias);
                    String path = elm.attribute("path").getValue();
                    logic.put("path", "logics/" + path);
                    String log = elm.attributeValue("log");
                    logic.put("log", log);
                    String mobile = elm.attributeValue("mobile");
                    logic.put("mobile", mobile);
                    map.put(alias, logic);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String path = elm.attributeValue("path");
            LogicMapper.putMap(name, reader, path);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                LogicMapper.putMap(childname, reader, name);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        String str = parent == null ? name + "/logic.xml" : parent + "/" + name + "/logic.xml";
        InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);
        if (moduleLogic == null) {
            throw new RuntimeException("\u6ce8\u610f\uff01\uff01\uff01\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + str);
        }
        Document docLogic = reader.read(moduleLogic);
        Element rootLogic = docLogic.getRootElement();
        Iterator item = rootLogic.elementIterator("logic");
        while (item.hasNext()) {
            Element elmment = (Element)item.next();
            String aliasLogic = elmment.attribute("alias").getValue();
            String pathLogic = elmment.attribute("path").getValue();
            String log = elmment.attributeValue("log");
            String mobile = elmment.attributeValue("mobile");
            if (map.containsKey(aliasLogic)) {
                throw new Exception("\u522b\u540d" + aliasLogic + "\u5df2\u5b58\u5728");
            }
            String path = (parent == null ? name + "/logics/" : parent + "/" + name + "/logics/") + pathLogic;
            HashMap<String, String> logic = new HashMap<String, String>();
            logic.put("alias", aliasLogic);
            logic.put("path", path);
            logic.put("log", log);
            logic.put("mobile", mobile);
            map.put(aliasLogic, logic);
        }
    }

    static {
        LogicMapper.loadMap();
    }
}

