package com.aote.logic;

import com.aote.module.ModuleMapper;
import com.aote.sql.SqlMapper;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 业务插件映射器
 * @author HNS
 *
 */
@Component
public class PluginMapper implements ApplicationContextAware
 {
 	//注意是static的
	private static ApplicationContext applicationContext;

	static Logger log = Logger.getLogger(PluginMapper.class);

	private static Map<String, Object> map = null;

	 /**
	  * Spring启动的时候会自动调用下面的方法设置ApplicationContext的值
	  */
	 @Override
	 public void setApplicationContext(ApplicationContext ctx) throws BeansException {
		 applicationContext = ctx;
		 //初始化即加载,之所以放到该方法里，是因为statc静态块比该方法先执行，会导致applicationContext对象为null
		 map = loadMap();
	 }

	public static Map<String, Object> getPlugins() {
		return map;
	}

	@SuppressWarnings("rawtypes")
	private static Map<String, Object> loadMap() {
		// 先获取自身的插件
		Map<String, Object> result = innerLoadMap("");
		// 获取所有模块的插件
		Map<String, Map<String, String>> map = ModuleMapper.getMap();
		for(String key : map.keySet()) {
			Map<String, String> modules = map.get(key);
			Map<String, Object> plugins;
			if(modules.get("path") != null){
				plugins = innerLoadMap(modules.get("path"),key);
			} else {
				plugins = innerLoadMap(key);
			}
			result.putAll(plugins);
		}
		return result;
	}

	private static Map<String, Object> innerLoadMap(String module) {
	 	return innerLoadMap("",module);
	}

	 private static Map<String, Object> innerLoadMap(String path,String module) {
		 Map<String, Object> map = new HashMap<>();

		 // module要添加路径分隔符
		 if (!"".equals(path)) {
			 path += "/";
		 }
		 // module要添加路径分隔符
		 if (!"".equals(module)) {
			 module += "/";
		 }
		 if (ResourceHelper.class.getResourceAsStream("/"+ path + module + "plugins.xml") == null) {
			 log.warn("无plugins.xml文件");
			 return map;
		 }

		 SAXReader reader = new SAXReader();
		 InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream(path + module + "plugins.xml");
		 Document document;
		 try {
			 document = reader.read(input);
		 } catch (DocumentException e) {
			 throw new RuntimeException(e);
		 }
		 Element root = document.getRootElement();
		 for (Iterator it = root.elementIterator("plugin"); it.hasNext();) {
			 Element elm = (Element) it.next();
			 String alias = elm.attribute("alias").getValue();
			 String className = elm.attribute("class").getValue();
			 try {
				 Class c = Class.forName(className);
				 Object obj;
				 // 如果是spring的bean，让spring取
				 if(isSpring(c)) {
					 obj = applicationContext.getBean(c);
				 } else {
					 obj = c.newInstance();
					 // 如果实现了插件Bean注入工具
					 if (obj instanceof SpringBeansPour) {
						 ((SpringBeansPour)obj).initBeans(applicationContext);
					 }
				 }
				 map.put(alias, obj);
			 } catch (ClassNotFoundException ex) {
				 log.error("未找到类, 模块=" + module + ", 类=" + ex.getMessage());
			 } catch (RuntimeException ex) {
				 throw ex;
			 } catch (Throwable ex) {
				 throw new RuntimeException(ex);
			 }
		 }
		 return map;
	 }

	// 看类是否有@Component注解
	public static boolean isSpring(Class c) {
		for (Annotation annotation : c.getAnnotations()) {
			if(annotation.annotationType() == Component.class) {
				return true;
			}
		}
		return false;
	}

	public void main(String[] args) {
		PluginMapper.loadMap();
		for(String key : map.keySet()) {
			System.out.println(key);
		}
	}
}
