/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="sql")
@Component
@Transactional
public class SqlService {
    static Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;

    @GET
    @Path(value="/clear")
    public String clearSQLCache() {
        ResourceHelper.clearSqlCache();
        return "ok";
    }

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 1, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 2, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 3, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}")
    public String txHqlExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 4, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/all")
    public String txHqlExecuteAll(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 5, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    private String sqlEncrypt(String sqlName, String param, int method, int ... value) throws Exception {
        switch (method) {
            case 1: {
                return this.sqlServer.queryTotal(sqlName, param).toString();
            }
            case 2: {
                return this.sqlServer.query(sqlName, value[0], value[1], param).toString();
            }
            case 3: {
                return this.sqlServer.queryHqlTotal(sqlName, param).toString();
            }
            case 4: {
                return this.sqlServer.hqlQuery(sqlName, value[0], value[1], param).toString();
            }
        }
        return this.sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString();
    }
}

