/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.module.ModuleMapper;
import com.aote.path.PathServer;
import com.aote.rs.ManagerService;
import com.aote.sql.SqlServer;
import com.aote.util.LdapHelper;
import com.aote.util.ResourceHelper;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="product")
@Singleton
@Component
public class ProductService {
    static Logger log = Logger.getLogger(ProductService.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private LogicServer logicServer;
    private boolean shouldInit = true;

    public void setShouldInit(boolean shouldInit) {
        this.shouldInit = shouldInit;
    }

    @POST
    @Transactional
    @Path(value="getparam")
    public String xtGetParam() throws Exception {
        String key;
        JSONObject param;
        String path = "t_parameter.(**)";
        JSONArray array = this.pathServer.query(path);
        String getSingle = "t_singlevalue.(*)";
        JSONArray singles = this.pathServer.query(getSingle);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("d:/param.json"), StandardCharsets.UTF_8);
        writer.write("{\n");
        for (Object o : array) {
            param = (JSONObject)o;
            key = param.getString("name");
            JSONArray paramValue = new JSONArray();
            JSONArray paramArray = param.getJSONArray("f_paramvalues");
            for (Object obj : paramArray) {
                JSONObject paramJson = (JSONObject)obj;
                String value = paramJson.getString("name");
                paramValue.put((Object)value);
            }
            String result = "\t\"" + key + "\":" + paramValue.toString() + ",\n";
            writer.write(result);
        }
        for (Object o : singles) {
            param = (JSONObject)o;
            key = param.getString("name");
            String value = param.getString("value");
            String result = "\t\"" + key + "\":" + value + ",\n";
            writer.write(result);
        }
        writer.write("}\n");
        ((Writer)writer).close();
        return "";
    }

    @PostConstruct
    public void init() {
        try {
            if (this.shouldInit) {
                this.entityServer.initParam();
                this.loadFunctions();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.toString());
        }
    }

    private void runInitialLogic(String module) {
        try {
            if (LogicMapper.getLogic(module + "Install") == null) {
                return;
            }
            JSONObject params = new JSONObject();
            params.put("data", (Object)new JSONObject());
            this.logicServer.run(module + "Install", params);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadFunctions() {
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        for (String key : map.keySet()) {
            this.innerLoadFunctions(key);
            this.runInitialLogic(key);
        }
    }

    private void innerLoadFunctions(String module) {
        try {
            if (!"".equals(module)) {
                module = module + "/";
            }
            if (ResourceHelper.class.getResourceAsStream("/" + module + "function.json") == null) {
                return;
            }
            String strConfig = ResourceHelper.getString(module + "function.json");
            JSONObject json = new JSONObject(strConfig);
            JSONObject conf = ManagerService.getJsonConfig();
            if (!conf.has("ldap")) {
                log.error((Object)("config.json\u65e0ldap\u914d\u7f6e\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u529f\u80fd\uff01module=" + module));
                return;
            }
            String ldap = conf.getString("ldap");
            String funcRootStr = LdapHelper.search(ldap, "{source: 'root.getChildByName($\u529f\u80fd\u6a21\u5757$)', userid: ''}");
            JSONObject funcRoot = new JSONObject(funcRootStr);
            String parentid = funcRoot.getString("id");
            log.info((Object)("\u5f00\u59cb\u5bf9\u529f\u80fd\u521d\u59cb\u5316\u3002module=" + module));
            JSONObject functions = json.getJSONObject("functions");
            for (String key : functions.keySet()) {
                JSONObject func = functions.getJSONObject(key);
                this.procOneFunction(key, func, parentid, ldap);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String procOneFunction(String name, JSONObject funcJson, String parentid, String url) {
        try {
            String id;
            JSONObject func = new JSONObject();
            for (String key : funcJson.keySet()) {
                Object obj = funcJson.get(key);
                if (obj instanceof JSONObject) continue;
                func.put(key, obj);
            }
            String str = "{source: 'tool.toList(this.getChildren()).where(row.attributes.get($name$)==$" + name + "$)', userid: '" + parentid + "'}";
            String result = LdapHelper.search(url, str);
            JSONArray array = new JSONArray(result);
            if (array.length() == 0) {
                func.put("resourcetype", (Object)"function");
                func.put("name", (Object)name);
                func.put("id", (Object)"");
                id = LdapHelper.saveChild(url, parentid, func);
            } else {
                id = array.getJSONObject(0).getString("id");
            }
            for (String key : funcJson.keySet()) {
                Object obj = funcJson.get(key);
                if (!(obj instanceof JSONObject)) continue;
                JSONObject json = (JSONObject)obj;
                this.procOneFunction(key, json, id, url);
            }
            return id;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

