/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.redis.RedisUtil;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import com.aote.util.other.RedisTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Component
@Transactional
public class LogicServer {
    static Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    public SessionPool sessionPool;
    @Autowired
    public SessionFactory sessionFactory;
    private JSONObject context = null;

    public Object run(String name, String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                param = new JSONObject(str);
                if (!param.isNull("context")) {
                    this.context = param.getJSONObject("context");
                }
                if (!param.isNull("data")) {
                    Object dataParam = param.get("data");
                    param = dataParam instanceof String ? new JSONObject(param.getString("data")) : param.getJSONObject("data");
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param, this.context);
    }

    public Object run(String name, JSONObject param, JSONObject context) {
        String source;
        String path = LogicMapper.getLogic(name);
        if (path == null) {
            throw new RuntimeException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        try {
            source = ResourceHelper.getString(ResourceType.LOGIC, name, path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        if (context != null) {
            params.put("context", context);
        }
        params.put("log", this);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("path", this.pathServer);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", this.redisUtil);
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        params.putAll(plugins);
        return ExpressionHelper.run(source, params);
    }

    public Object run(String name, JSONObject param) {
        return this.run(name, param, this.context);
    }

    public void fatal(Object msg) {
        log.fatal(msg);
    }

    public void error(Object msg) {
        log.error(msg);
    }

    public void warn(Object msg) {
        log.warn(msg);
    }

    public void debug(Object msg) {
        log.debug(msg);
    }

    public void info(Object msg) {
        log.info(msg);
    }

    public void trace(Object msg) {
        log.trace(msg);
    }

    public void debug(String logic, Object msg) {
        String level = LogicMapper.getAttr(logic, "log");
        if (level != null) {
            log.debug((Object)(logic + ":" + msg));
        }
    }

    public void redisCacheLogic() throws Exception {
        if (ResourceHelper.class.getResourceAsStream("/config.json") == null) {
            log.info((Object)"\u65e0config.json\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            return;
        }
        String strConfig = ResourceHelper.getString("config.json");
        JSONObject jsonObject = new JSONObject(strConfig);
        if (!jsonObject.has("logicRegister")) {
            log.info((Object)"config.json\u4e2d\u65e0\u6a21\u5757\u955c\u50cf\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            return;
        }
        JSONObject logicJsonObject = jsonObject.getJSONObject("logicRegister");
        String url = logicJsonObject.getString("url");
        if (url == null) {
            log.info((Object)"config.json\u4e2d\u65e0url\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            return;
        }
        try {
            JSONObject redisObject = logicJsonObject.getJSONObject("redis");
            String redisHost = redisObject.getString("host");
            int redisPort = redisObject.getInt("port");
            String redispwd = "";
            try {
                redispwd = redisObject.getString("redispwd");
            }
            catch (JSONException e) {
                log.info((Object)"\u65e0redis\u5bc6\u7801");
            }
            RedisTools.getJedisPool(redisHost, redisPort);
            Map<String, Map<String, String>> map = LogicMapper.getMap();
            if (map != null) {
                for (String key : map.keySet()) {
                    if ("".equals(redispwd)) {
                        RedisTools.setValue(key, url);
                    } else {
                        RedisTools.setValue(key, url, redispwd);
                    }
                    log.info((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = SqlMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    if ("".equals(redispwd)) {
                        RedisTools.setValue(key, url);
                    } else {
                        RedisTools.setValue(key, url, redispwd);
                    }
                    log.info((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = PathMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    if ("".equals(redispwd)) {
                        RedisTools.setValue(key, url);
                    } else {
                        RedisTools.setValue(key, url, redispwd);
                    }
                    log.info((Object)("path\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            Map entities = this.sessionFactory.getAllClassMetadata();
            for (String key : entities.keySet()) {
                if ("".equals(redispwd)) {
                    RedisTools.setValue(key, url);
                } else {
                    RedisTools.setValue(key, url, redispwd);
                }
                log.info((Object)("entity\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
            }
        }
        catch (JedisConnectionException e) {
            log.warn((Object)"\u65e0\u6cd5\u8fde\u63a5redis\u670d\u52a1\u5668\uff0c\u672a\u6210\u529f\u6ce8\u518c\u4e1a\u52a1\u903b\u8f91\u7b49\u7ec4\u4ef6\uff01");
        }
    }
}

