/*
 * Decompiled with CFR 0.152.
 */
package com.aote.entity;

import com.af.util.Pair;
import com.aote.entity.RulesValidation;
import com.aote.module.ModuleMapper;
import com.aote.path.PathServer;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.id.Assigned;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.internal.SessionImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class EntityServer {
    private static final String DIALECT_SQLSERVER = "SqlServer";
    private static final String DIALECT_ORACLE = "Oracle";
    private static final String COL_STRING = "STRING";
    private static final String COL_DATE = "DATE";
    private static final String COL_TIME = "TIME";
    private static final String COL_BOOLEAN = "BOOLEAN";
    private static final String COL_NUMBER = "NUMBER";
    private static final String COL_NOTSUPPORTED = "NOT_SUPPORTED";
    private static final String ID_GUID = "ID_GUID";
    private static final String ID_SEQ = "ID_SEQ";
    private static final String ID_AUTO = "ID_AUTO";
    private static final String ID_ASSIGNED = "ID_ASSIGNED";
    private static final String ID_FOREIGNER = "ID_FOREIGNER";
    public static HashMap<String, HashMap<String, Object>> metaMap = new HashMap();
    public static HashMap<String, String> entityLiftMap = new HashMap();
    static Logger log = Logger.getLogger(EntityServer.class);
    @Autowired
    public SessionFactory sessionFactory;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private SessionPool sessionPool;

    @Deprecated
    public String save(String entityName, String values) throws Exception {
        Session session = this.sessionPool.getSession();
        JSONObject object = new JSONObject(values);
        JSONObject data = object.getJSONObject("data");
        Map<String, Object> map = JsonHelper.toMap(data, entityName, this.sessionFactory);
        JSONObject result = this.save(session, entityName, map);
        return result.toString();
    }

    @Deprecated
    public String save(String entityName, Map<String, Object> map) throws Exception {
        Session session = this.sessionPool.getSession();
        Map<String, Object> data = JsonHelper.toMap(map, entityName, this.sessionFactory);
        JSONObject result = this.save(session, entityName, data);
        return result.toString();
    }

    @Deprecated
    public Object save(String entityName, JSONObject json) throws Exception {
        Session session = this.sessionPool.getSession();
        Map<String, Object> data = JsonHelper.toMap(json, entityName, this.sessionFactory);
        JSONObject result = this.save(session, entityName, data);
        return result.get("id");
    }

    public String delete(String entityName, String id) throws Exception {
        HashMap<String, Object> map = metaMap.get(entityName);
        String hql = "delete from " + map.get("tableName") + " where " + map.get("idName") + "=" + this.normalizeValue(this.findDialect(), id, (String)map.get("idType"));
        SqlHelper.bulkSQLUpdate(this.sessionPool.getSession(), hql);
        return "ok";
    }

    private JSONObject save(Session session, String entityName, Map<String, Object> map) {
        Serializable id;
        JSONObject result = new JSONObject();
        if (map.containsKey("id")) {
            session.update(entityName, map);
            id = (Serializable)map.get("id");
        } else {
            id = session.save(entityName, map);
        }
        session.flush();
        session.evict(session.load(entityName, id));
        result.put("id", (Object)id);
        return result;
    }

    public String findDialect() throws Exception {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)this.sessionFactory;
        String dialect = sf.getDialect().toString().toLowerCase();
        if (dialect.contains("sqlserver")) {
            return DIALECT_SQLSERVER;
        }
        if (dialect.contains("oracle")) {
            return DIALECT_ORACLE;
        }
        throw new Exception("\u6570\u636e\u5e93\u65b9\u8a00\u914d\u7f6e\u5f02\u5e38\u3002");
    }

    private String normalizeType(String type) {
        switch (type = type.toLowerCase()) {
            case "string": {
                return COL_STRING;
            }
            case "date": {
                return COL_DATE;
            }
            case "time": 
            case "timestamp": {
                return COL_TIME;
            }
            case "boolean": 
            case "yes_no": {
                return COL_BOOLEAN;
            }
            case "integer": 
            case "double": 
            case "big_decimal": 
            case "big_integer": {
                return COL_NUMBER;
            }
        }
        return COL_NOTSUPPORTED;
    }

    private HashMap<String, Object> getMetaData(String entityName) throws Exception {
        if (metaMap.containsKey(entityName)) {
            return metaMap.get(entityName);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityName", entityName);
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(entityName);
        AbstractEntityPersister aep = (AbstractEntityPersister)cmd;
        map.put("tableName", aep.getTableName());
        String attr = cmd.getIdentifierPropertyName();
        if (attr == null) {
            log.warn((Object)("\u505c\u6b62\u5904\u7406\u3010" + entityName + "\u3011\u7684\u6620\u5c04\uff0c\u53ef\u80fd\u542b\u6709\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7ed3\u6784"));
            return null;
        }
        map.put("idName", attr);
        map.put("idColName", aep.getPropertyColumnNames(attr)[0]);
        String idType = this.normalizeType(cmd.getIdentifierType().getName());
        map.put("idType", idType);
        IdentifierGenerator idg = aep.getIdentifierGenerator();
        if (idg instanceof GUIDGenerator || idg instanceof UUIDGenerator || idg instanceof UUIDHexGenerator) {
            map.put("idGenerator", ID_GUID);
        } else if (idg instanceof SequenceGenerator) {
            String name = ((SequenceGenerator)idg).getSequenceName();
            this.createSequence(name);
            map.put("sequence", name);
            map.put("idGenerator", ID_SEQ);
        } else if (idg instanceof IdentityGenerator) {
            map.put("idGenerator", ID_AUTO);
        } else if (idg instanceof Assigned) {
            map.put("idGenerator", ID_ASSIGNED);
        } else if (idg instanceof ForeignGenerator) {
            map.put("idGenerator", ID_FOREIGNER);
        } else {
            throw new Exception("Unsupported id generator strategy:" + idg.getClass().getName());
        }
        if (cmd.isVersioned()) {
            attr = cmd.getPropertyNames()[cmd.getVersionProperty()];
            map.put("verName", attr);
            map.put("verColName", aep.getPropertyColumnNames(attr)[0]);
            map.put("verType", this.normalizeType(cmd.getPropertyType(attr).getName()));
        }
        HashMap<String, Pair> columns = new HashMap<String, Pair>();
        map.put("columns", columns);
        HashMap<String, Pair> links = new HashMap<String, Pair>();
        map.put("links", links);
        HashMap<String, Pair> onetoone = new HashMap<String, Pair>();
        map.put("onetoone", onetoone);
        HashMap<String, Pair> onetomany = new HashMap<String, Pair>();
        map.put("onetomany", onetomany);
        for (String property : cmd.getPropertyNames()) {
            Type type = cmd.getPropertyType(property);
            log.debug((Object)("property: " + property + "," + type.getClass().getName()));
            if (type instanceof CollectionType || type instanceof OneToOneType) {
                String link;
                String linkEntity;
                Joinable ja;
                CollectionType st;
                SessionFactoryImplementor sf = (SessionFactoryImplementor)this.sessionFactory;
                if (type instanceof CollectionType) {
                    st = (CollectionType)type;
                    ja = st.getAssociatedJoinable(sf);
                    linkEntity = st.getAssociatedEntityName(sf);
                } else {
                    st = (OneToOneType)type;
                    ja = st.getAssociatedJoinable(sf);
                    linkEntity = st.getAssociatedEntityName(sf);
                    log.debug((Object)("one-to-one direction: " + st.getForeignKeyDirection()));
                }
                String foreignkey = ja.getKeyColumnNames()[0];
                if (type instanceof OneToOneType) {
                    link = property;
                } else {
                    HashMap pkfk;
                    link = ja.getName().substring(entityName.length() + 1);
                    HashMap<String, Object> linkedMap = linkEntity.equals(entityName) ? map : this.getMetaData(linkEntity);
                    assert (linkedMap != null);
                    if (linkedMap.containsKey("associations")) {
                        pkfk = (HashMap)linkedMap.get("associations");
                        pkfk.put(entityName, new Pair(foreignkey, idType));
                    } else {
                        pkfk = new HashMap();
                        pkfk.put(entityName, new Pair(foreignkey, idType));
                        linkedMap.put("associations", pkfk);
                    }
                }
                links.put(link, new Pair(linkEntity, foreignkey));
                if (type instanceof CollectionType) {
                    onetomany.put(link, new Pair(linkEntity, foreignkey));
                    continue;
                }
                onetoone.put(link, new Pair(linkEntity, foreignkey));
                continue;
            }
            if (type instanceof ManyToOneType) continue;
            String columnName = ((AbstractEntityPersister)cmd).getPropertyColumnNames(property)[0];
            columns.put(property, new Pair(columnName, this.normalizeType(type.getName())));
        }
        metaMap.put(entityName, map);
        return map;
    }

    private void createSequence(String name) {
        String sql = "CREATE SEQUENCE " + name + "\nSTART WITH 1\nNOMAXvalue\nINCREMENT BY 1\nNOCYCLE\nCACHE 10\n";
        try {
            this.sqlServer.run(sql);
        }
        catch (SQLGrammarException e) {
            log.info((Object)("sequence\u521b\u5efa\u5931\u8d25\uff1a" + name));
        }
    }

    public <T extends Serializable> T deepClone(T o) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        return (T)((Serializable)o.getClass().cast(in.readObject()));
    }

    private void enchanceMetaData(HashMap<String, Object> pmd, String entityName) throws Exception {
        HashMap<String, Object> md = metaMap.get(entityName);
        HashMap links = (HashMap)md.get("links");
        HashMap plinks = (HashMap)pmd.get("links");
        for (String key : links.keySet()) {
            plinks.put(key, this.deepClone((Serializable)links.get(key)));
        }
        HashMap sub = md.containsKey("subclasses") ? (HashMap)md.get("subclasses") : new HashMap();
        HashMap psub = pmd.containsKey("subclasses") ? (HashMap)pmd.get("subclasses") : new HashMap();
        for (String key : sub.keySet()) {
            psub.put(key, this.deepClone((Serializable)sub.get(key)));
        }
        HashMap inv = (HashMap)md.get("inverses");
        HashMap pinv = (HashMap)pmd.get("inverses");
        for (String key : inv.keySet()) {
            pinv.put(key, inv.get(key));
        }
        HashMap invid = md.containsKey("inverseid") ? (HashMap)md.get("inverseid") : new HashMap();
        HashMap pinvid = pmd.containsKey("inverseid") ? (HashMap)pmd.get("inverseid") : new HashMap();
        for (String key : invid.keySet()) {
            pinvid.put(key, this.deepClone((Serializable)invid.get(key)));
        }
    }

    public String partialSave(String entityName, JSONObject row) throws Exception {
        HashMap md;
        if (entityLiftMap.containsKey(entityName)) {
            String pEntityName = entityLiftMap.get(entityName);
            md = (HashMap)this.deepClone((Serializable)metaMap.get(pEntityName));
            this.enchanceMetaData(md, entityName);
        } else {
            md = metaMap.get(entityName);
        }
        String dialect = this.findDialect();
        Serializable aid = this.partialSave(row, md, null, null, dialect);
        JSONObject result = new JSONObject();
        result.put((String)md.get("idName"), (Object)aid.toString());
        return result.toString();
    }

    public String partialSave2(String entityName, JSONObject row) throws Exception {
        HashMap md;
        if (entityLiftMap.containsKey(entityName)) {
            String pEntityName = entityLiftMap.get(entityName);
            md = (HashMap)this.deepClone((Serializable)metaMap.get(pEntityName));
            this.enchanceMetaData(md, entityName);
        } else {
            md = metaMap.get(entityName);
        }
        String dialect = this.findDialect();
        int count = 1;
        while (true) {
            try {
                Serializable aid = this.partialSave(row, md, null, null, dialect);
                JSONObject result = new JSONObject();
                result.put((String)md.get("idName"), (Object)aid.toString());
                return result.toString();
            }
            catch (WebException e) {
                if (e.status == 505 && count <= 3) {
                    log.info((Object)("\u7248\u672c\u53f7\u5f02\u5e38\uff0c\u7b2c" + count + "\u6b21\u5c1d\u8bd5..."));
                    row.put("version", row.getInt("version") + 1);
                    ++count;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public String partialSave(String entityName, String values) throws Exception {
        JSONObject row = new JSONObject(values);
        return this.partialSave(entityName, row);
    }

    private Serializable partialSave(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect) throws Exception {
        int affectedRows;
        Object idValue = null;
        String idName = (String)md.get("idName");
        String idType = (String)md.get("idType");
        if (row.has(idName)) {
            idValue = row.get(idName);
        }
        HashMap columns = (HashMap)md.get("columns");
        HashMap links = (HashMap)md.get("links");
        boolean isInsert = false;
        if (idValue == null || idValue == JSONObject.NULL) {
            affectedRows = this.doInsert(row, md, pIdValue, pEntityName, dialect, idName, idType, columns);
        } else if (!md.get("idGenerator").equals(ID_ASSIGNED)) {
            affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, dialect, idValue, idType, columns);
        } else if (this.hasKeyRow(dialect, (String)md.get("tableName"), (String)md.get("idColName"), idValue, idType)) {
            affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, dialect, idValue, idType, columns);
        } else {
            isInsert = true;
            affectedRows = this.doInsert(row, md, pIdValue, pEntityName, dialect, idName, idType, columns);
        }
        if (affectedRows == 0) {
            log.error((Object)"\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5728\u5176\u4ed6\u5730\u65b9\u53ef\u80fd\u88ab\u4fee\u6539\u3002");
            throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5728\u5176\u4ed6\u5730\u65b9\u53ef\u80fd\u88ab\u4fee\u6539\u3002");
        }
        idValue = row.get(idName);
        if (isInsert) {
            row.remove(idName);
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!links.containsKey(attr) || !row.has(attr)) continue;
            Pair pair = (Pair)links.get(attr);
            HashMap<String, Object> cmd = metaMap.get(pair.col);
            String cEntityName = (String)md.get("entityName");
            if (row.isNull(attr)) {
                if (!pair.col.equals(attr)) continue;
                this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), row.get(idName), idType);
                continue;
            }
            Object obj = row.get(attr);
            if (obj instanceof JSONArray) {
                JSONArray rows = row.getJSONArray(attr);
                for (int i = 0; i < rows.length(); ++i) {
                    this.partialSave(rows.getJSONObject(i), cmd, idValue, cEntityName, dialect);
                }
                continue;
            }
            this.partialSave((JSONObject)obj, cmd, idValue, cEntityName, dialect);
        }
        return (Serializable)idValue;
    }

    private void deleteOneToOne(String dialect, String tableName, String idCol, Object idValue, String idType) {
        String sql = "delete from " + tableName + " where " + idCol + "=" + this.normalizeValue(dialect, idValue, idType);
        log.info((Object)("\u4e00\u5bf9\u4e00\u5220\u9664sql:" + sql));
        this.SQLUpdate(sql);
    }

    private boolean hasKeyRow(String dialect, String tableName, String idColName, Object idValue, String idType) {
        return this.sessionPool.getSession().createSQLQuery("select 1 from " + tableName + " where " + idColName + "=" + this.normalizeValue(dialect, idValue, idType)).list().size() > 0;
    }

    private int doUpdate(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect, Object idValue, String idType, HashMap<String, Pair> columns) throws Exception {
        HashMap associations;
        if (row.keySet().size() == 1) {
            return -1;
        }
        RulesValidation.ruleValidation(row, (String)md.get("entityName"), "update");
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        StringBuilder sb = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null && associations.containsKey(pEntityName)) {
            Pair pair = (Pair)associations.get(pEntityName);
            foreignkey = pair.col;
            sb.append(" ").append(foreignkey).append("=").append(this.normalizeValue(dialect, pIdValue, pair.type)).append(", ");
        }
        if (verName != null) {
            sb.append(" ").append(verName).append("=").append(this.normalizeVer(dialect, verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sb.append(" ").append(pair.col).append("=").append(row.isNull(attr) ? "null, " : this.normalizeValue(dialect, row.get(attr), pair.type) + ", ");
        }
        if (sb.length() == 0) {
            log.error((Object)("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row.toString()));
            throw new Exception("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row.toString());
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.insert(0, "update " + md.get("tableName") + " set ");
        sb.append(" where ").append(md.get("idColName")).append(" = ").append(this.normalizeValue(dialect, idValue, idType));
        if (md.get("verName") != null) {
            sb.append(" and ").append(md.get("verColName")).append("=").append(this.normalizeValue(dialect, verValue, verType));
        }
        log.info((Object)("\u751f\u6210\u7684\u66f4\u65b0sql: " + sb));
        int affectedRow = this.SQLUpdate(sb.toString());
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuilder buf = new StringBuilder();
                HashMap<String, Object> smd = metaMap.get(sentity);
                String keyAttr = (String)smd.get("idName");
                HashMap attrs = (HashMap)smd.get("columns");
                for (String attr : attrs.keySet()) {
                    if (attr.equals(keyAttr) || !row.has(attr)) continue;
                    p = (Pair)attrs.get(attr);
                    buf.append(p.col).append("=").append(this.normalizeValue(dialect, row.isNull(attr) ? null : row.get(attr), p.type)).append(", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.insert(0, "update " + smd.get("tableName") + " set ");
                buf.append(" where ").append(smd.get("idColName")).append(" = ").append(this.normalizeValue(dialect, idValue, idType));
                log.info((Object)("\u751f\u6210\u7684\u5b50\u66f4\u65b0sql: " + buf));
                this.SQLUpdate(buf.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair = (Pair)links.get(attr);
                    HashMap<String, Object> cmd = metaMap.get(pair.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr)) {
                        if (!pair.col.equals(attr)) continue;
                        this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), idValue, idType);
                        continue;
                    }
                    Object obj = row.get(attr);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, idValue, cEntityName, dialect);
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, idValue, cEntityName, dialect);
                }
                break block1;
            }
        }
        this.handleInverses(row, md, dialect);
        return affectedRow;
    }

    private void handleInverses(JSONObject row, HashMap<String, Object> md, String dialect) throws Exception {
        HashMap inverses = (HashMap)md.get("inverses");
        for (String inverse : inverses.keySet()) {
            Object arow;
            if (row.isNull(inverse) || !((arow = row.get(inverse)) instanceof JSONObject)) continue;
            HashMap<String, Object> amd = metaMap.get(inverses.get(inverse));
            this.partialSave((JSONObject)arow, amd, null, null, dialect);
        }
    }

    private int doInsert(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect, String idName, String idType, HashMap<String, Pair> columns) throws Exception {
        int affectedRows;
        String idStrategy;
        HashMap associations;
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        String idColName = (String)md.get("idColName");
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null) {
            for (String ass : associations.keySet()) {
                if (!ass.equals(pEntityName) && !this.hasParent(ass, pEntityName)) continue;
                Pair pair = (Pair)associations.get(ass);
                foreignkey = pair.col;
                if (sbCols.indexOf(foreignkey + ",") != -1) continue;
                sbCols.append(foreignkey).append(", ");
                sbValues.append(this.normalizeValue(dialect, pIdValue, pair.type)).append(", ");
            }
        }
        if (verName != null) {
            sbCols.append(verName).append(", ");
            sbValues.append(this.normalizeVer(dialect, verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            String pair = columns.get(attr);
            sbCols.append(((Pair)pair).col).append(", ");
            sbValues.append(row.isNull(attr) ? "null, " : this.normalizeValue(dialect, row.get(attr), ((Pair)pair).type) + ", ");
        }
        switch (idStrategy = (String)md.get("idGenerator")) {
            case "ID_GUID": {
                sbCols.append(idColName).append(", ");
                String guid = UUID.randomUUID().toString().replace("-", "");
                sbValues.append("'").append(guid).append("', ");
                row.put(idName, (Object)guid);
                break;
            }
            case "ID_SEQ": {
                sbCols.append(idColName).append(", ");
                String aid = this.getLastSeqId((String)md.get("sequence"));
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
            case "ID_ASSIGNED": {
                sbCols.append(idColName).append(", ");
                sbValues.append(this.normalizeValue(dialect, row.get(idName), idType)).append(", ");
                row.put(idName, row.get(idName));
                break;
            }
            case "ID_FOREIGNER": {
                sbCols.append(idColName).append(", ");
                String aid = this.normalizeValue(dialect, pIdValue, idType);
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
        }
        if (md.containsKey("inverses")) {
            HashMap inverses = (HashMap)md.get("inverses");
            HashMap inversesid = (HashMap)md.get("inverseid");
            for (String inverse : inverses.keySet()) {
                if (row.isNull(inverse)) continue;
                Object arow = row.get(inverse);
                log.debug((Object)"\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:");
                if (!(arow instanceof JSONObject)) {
                    Pair pair = (Pair)inversesid.get(inverse);
                    sbCols.append(pair.col).append(", ");
                    sbValues.append(this.normalizeValue(dialect, arow, pair.type)).append(", ");
                    log.debug((Object)("\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:\u5c5e\u6027:" + pair.col + "\uff0c\u503c\uff1a" + arow));
                    continue;
                }
                sbCols.append(inverse).append(", ");
                JSONObject json = (JSONObject)arow;
                Pair pair = (Pair)inversesid.get(inverse);
                arow = json.get(pair.col);
                sbValues.append(this.normalizeValue(dialect, arow, pair.type)).append(", ");
                log.debug((Object)("\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:\u5c5e\u6027:" + pair.col + "\uff0c\u503c\uff1a" + arow));
            }
        }
        sbCols.delete(sbCols.length() - 2, sbCols.length());
        sbCols.insert(0, "insert into " + md.get("tableName") + " (");
        sbValues.delete(sbValues.length() - 2, sbValues.length());
        sbCols.append(") values (");
        sbCols.append((CharSequence)sbValues);
        sbCols.append(")");
        log.info((Object)("\u751f\u6210\u7684\u63d2\u5165sql\uff1b" + sbCols));
        if (idStrategy.equals(ID_AUTO)) {
            Pair pair = this.rawJdbcUpdate(sbCols.toString());
            row.put(idName, (Object)pair.type);
            affectedRows = Integer.parseInt(pair.col);
        } else {
            affectedRows = this.SQLUpdate(sbCols.toString());
        }
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                HashMap associations2;
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuilder fields = new StringBuilder();
                StringBuilder vals = new StringBuilder();
                HashMap<String, Object> smd = metaMap.get(sentity);
                String keyCol = (String)smd.get("idColName");
                fields.append(keyCol).append(", ");
                vals.append(this.normalizeValue(dialect, row.get(idName), idType)).append(", ");
                HashMap attrs = (HashMap)smd.get("columns");
                for (Object attr : attrs.keySet()) {
                    if (!row.has((String)attr)) continue;
                    p = (Pair)attrs.get(attr);
                    if (p.col.equals(foreignkey)) continue;
                    fields.append(p.col).append(", ");
                    vals.append(this.normalizeValue(dialect, row.isNull(attr) ? null : row.get(attr), p.type)).append(", ");
                }
                if (smd.containsKey("inverseid")) {
                    HashMap lookup = (HashMap)smd.get("inverseid");
                    for (String property : lookup.keySet()) {
                        if (!row.has(property) || row.isNull(property)) continue;
                        Object obj = row.get(property);
                        Pair pair = (Pair)lookup.get(property);
                        if (obj instanceof JSONObject) {
                            JSONObject record = (JSONObject)obj;
                            if (!record.has(pair.col) || record.isNull(pair.col)) continue;
                            fields.append(pair.col).append(", ");
                            vals.append(this.normalizeValue(dialect, record.get(pair.col), pair.type)).append(", ");
                            continue;
                        }
                        fields.append(pair.col).append(", ");
                        vals.append(this.normalizeValue(dialect, row.get(property), pair.type)).append(", ");
                    }
                }
                if ((associations2 = (HashMap)md.get("associations")) != null) {
                    for (String ass : associations2.keySet()) {
                        Pair pair = (Pair)associations2.get(ass);
                        foreignkey = pair.col;
                        if (!attrs.containsKey(foreignkey) || pIdValue == null || fields.indexOf(foreignkey + ", ") != -1) continue;
                        fields.append(foreignkey).append(", ");
                        vals.append(this.normalizeValue(dialect, pIdValue, pair.type)).append(", ");
                    }
                }
                fields.delete(fields.length() - 2, fields.length());
                vals.delete(vals.length() - 2, vals.length());
                fields.insert(0, "insert into " + smd.get("tableName") + " (");
                fields.append(") values (");
                fields.append((CharSequence)vals);
                fields.append(")");
                log.info((Object)("\u751f\u6210\u7684\u5b50\u63d2\u5165sql: " + fields));
                this.SQLUpdate(fields.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair = (Pair)links.get(attr);
                    HashMap<String, Object> cmd = metaMap.get(pair.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr)) {
                        if (!pair.col.equals(attr)) continue;
                        this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), row.get(idName), idType);
                        continue;
                    }
                    Object obj = row.get(attr);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, row.get(idName), cEntityName, dialect);
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, row.get(idName), cEntityName, dialect);
                }
                break block15;
            }
        }
        this.handleInverses(row, md, dialect);
        return affectedRows;
    }

    public List<String> getChildName(String tableName) {
        ArrayList<String> childTable = new ArrayList<String>();
        if (metaMap.containsKey(tableName)) {
            log.debug((Object)"Parents table is exist");
            HashMap<String, Object> map = metaMap.get(tableName);
            HashMap childmap = (HashMap)map.get("subclasses");
            if (childmap != null) {
                log.debug((Object)"Get all child tables");
                Set keys = childmap.keySet();
                childTable.addAll(keys);
            }
        }
        return childTable;
    }

    private boolean hasParent(String entity, String pEntityName) {
        if (entityLiftMap.containsKey(entity)) {
            return true;
        }
        while (entityLiftMap.containsKey(entity)) {
            String pEntity = entityLiftMap.get(entity);
            if (pEntity.equals(pEntityName)) {
                return true;
            }
            entity = pEntity;
        }
        return false;
    }

    private Pair rawJdbcUpdate(String sql) throws Exception {
        Pair pair = new Pair("", "");
        Connection con = ((SessionImpl)this.sessionPool.getSession()).connection();
        PreparedStatement statement = con.prepareStatement(sql, 1);
        int affectedRows = statement.executeUpdate();
        pair.col = affectedRows + "";
        if (affectedRows == 0) {
            return pair;
        }
        ResultSet rs = statement.getGeneratedKeys();
        if (!rs.next()) {
            throw new Exception("\u5f97\u5230\u63d2\u5165\u8bb0\u5f55id\u5931\u8d25\u3002");
        }
        pair.type = rs.getLong(1) + "";
        rs.close();
        statement.close();
        return pair;
    }

    private int SQLUpdate(String sql) {
        SQLQuery query = this.sessionPool.getSession().createSQLQuery(sql);
        return query.executeUpdate();
    }

    private String query(String sql) {
        SQLQuery query = this.sessionPool.getSession().createSQLQuery(sql);
        return query.list().get(0) + "";
    }

    private String getLastSeqId(String seq) {
        return this.query("select " + seq + ".nextval newid from dual");
    }

    private String normalizeVer(String dialect, Object verValue, String verType) {
        if (verType.equals(COL_TIME)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "current_timestamp";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + sdf.format(new Date()) + "'";
        }
        if (verValue == null) {
            return "1";
        }
        return Integer.parseInt(verValue + "") + 1 + "";
    }

    private String normalizeValue(String dialect, Object value, String valType) {
        if (value == null) {
            return "null";
        }
        switch (valType) {
            case "STRING": {
                return "'" + value + "'";
            }
            case "NUMBER": {
                if ("".equals(value)) {
                    return "null";
                }
                return value + "";
            }
            case "BOOLEAN": {
                if (dialect.equals(DIALECT_ORACLE)) {
                    return "'" + ((Boolean)value != false ? "Y" : "N") + "'";
                }
                if (value instanceof Byte) {
                    return value.toString();
                }
                if (value instanceof Integer) {
                    return value.toString();
                }
                return (Boolean)value != false ? "1" : "0";
            }
            case "DATE": {
                if (dialect.equals(DIALECT_ORACLE)) {
                    return "TO_DATE(SUBSTR('" + value + "', 1, 10), 'YYYY-MM-DD')";
                }
                return "'" + value + "'";
            }
            case "TIME": {
                if (dialect.equals(DIALECT_ORACLE)) {
                    return "TO_TIMESTAMP('" + value + "', 'YYYY-MM-DD HH24:MI:SS')";
                }
                return "'" + value + "'";
            }
        }
        throw new WebException(504, "\u4f20\u9012\u6570\u636e\u7c7b\u578b\u51fa\u9519");
    }

    public void loadMetaData() {
        Map map = this.sessionFactory.getAllClassMetadata();
        for (String entityName : map.keySet()) {
            try {
                this.getMetaData(entityName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SAXReader reader = new SAXReader();
        if (SqlMapper.class.getClassLoader().getResourceAsStream("subclass.xml") != null) {
            InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream("subclass.xml");
            this.loadSubclass(reader, input);
        }
        Map<String, Map<String, String>> maps = ModuleMapper.getSubClassMap();
        for (String moduleName : maps.keySet()) {
            if (!"".equals(moduleName)) {
                moduleName = moduleName + "/";
            }
            if (SqlMapper.class.getResourceAsStream("/" + moduleName + "subclass.xml") == null) {
                log.debug((Object)(moduleName + "\u6a21\u5757\u4e0b\u65e0subclass.xml\u6587\u4ef6"));
                continue;
            }
            InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream(moduleName + "subclass.xml");
            this.loadSubclass(reader, input);
        }
        for (String entityName : map.keySet()) {
            try {
                HashMap<String, Object> hash = metaMap.get(entityName);
                if (hash != null) {
                    ClassMetadata cmd = this.sessionFactory.getClassMetadata(entityName);
                    HashMap<String, String> inverses = new HashMap<String, String>(16);
                    hash.put("inverses", inverses);
                    HashMap<String, Pair> inverseMap = new HashMap<String, Pair>(16);
                    hash.put("inverseid", inverseMap);
                    for (String property : cmd.getPropertyNames()) {
                        Type type = cmd.getPropertyType(property);
                        if (!(type instanceof ManyToOneType)) continue;
                        ManyToOneType mto = (ManyToOneType)type;
                        String linkedEntity = mto.getAssociatedEntityName();
                        String colName = mto.getAssociatedJoinable((SessionFactoryImplementor)this.sessionFactory).getKeyColumnNames()[0];
                        inverses.put(property, linkedEntity);
                        inverseMap.put(property, new Pair(colName, (String)metaMap.get(linkedEntity).get("idType")));
                    }
                    continue;
                }
                log.warn((Object)("\u672a\u5904\u7406\u3010" + entityName + "\u3011\u7684\u53cd\u5411\u591a\u5bf9\u4e00\u5173\u7cfb\uff0c\u53ef\u80fd\u542b\u6709\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7ed3\u6784"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)"meta data all loaded.");
    }

    private void loadSubclass(SAXReader reader, InputStream input) {
        try {
            Document document = reader.read(input);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("entity");
            while (it.hasNext()) {
                HashMap subclasses;
                Element elm = (Element)it.next();
                String entityName = elm.attribute("name").getValue();
                String parentEntity = elm.attribute("parentEntity").getValue();
                String discriminator = elm.attribute("discriminator").getValue();
                String discProperty = elm.attribute("discProperty").getValue();
                if (!metaMap.containsKey(parentEntity)) continue;
                HashMap<String, Object> em = metaMap.get(parentEntity);
                if (em.containsKey("subclasses")) {
                    subclasses = (HashMap)em.get("subclasses");
                } else {
                    subclasses = new HashMap();
                    em.put("subclasses", subclasses);
                }
                subclasses.put(entityName, new Pair(discProperty, discriminator));
                entityLiftMap.put(entityName, parentEntity);
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void initParam() throws Exception {
        this.innerInitParam("");
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        for (String key : map.keySet()) {
            this.innerInitParam(key);
        }
    }

    private void innerInitParam(String module) throws Exception {
        if (!"".equals(module)) {
            module = module + "/";
        }
        if (ResourceHelper.class.getResourceAsStream("/" + module + "param.json") == null) {
            return;
        }
        String strConfig = ResourceHelper.getString(module + "param.json");
        String getParam = "t_parameter.(**)";
        JSONArray params = this.pathServer.query(getParam);
        String getSingle = "t_singlevalue.(*)";
        JSONArray singles = this.pathServer.query(getSingle);
        JSONObject json = new JSONObject(strConfig);
        for (String key : json.keySet()) {
            Object object = json.get(key);
            JSONObject param = new JSONObject();
            if (object instanceof JSONArray) {
                if (this.contains(params, "name", key)) continue;
                JSONArray array = new JSONArray(object.toString());
                param.put("name", (Object)key);
                JSONArray paramValues = new JSONArray();
                param.put("f_paramvalues", (Object)paramValues);
                for (Object obj : array) {
                    String value = (String)obj;
                    JSONObject paramValue = new JSONObject();
                    paramValue.put("name", (Object)value);
                    paramValues.put((Object)paramValue);
                }
                this.partialSave("t_parameter", param);
                continue;
            }
            if (this.contains(singles, "name", key)) continue;
            System.out.println("\u5355\u503c\uff1a" + object.toString());
            param.put("name", (Object)key);
            param.put("value", (Object)object.toString());
            this.partialSave("t_singlevalue", param);
        }
    }

    private boolean contains(JSONArray array, String key, String value) {
        for (Object obj : array) {
            JSONObject json = (JSONObject)obj;
            if (!json.get(key).equals(value)) continue;
            return true;
        }
        return false;
    }

    public JSONObject action(JSONObject params) {
        log.debug((Object)("action:" + params));
        String method = params.getString("method");
        if ("save".equals(method)) {
            String entity = params.getString("entity");
            JSONObject json = params.getJSONObject("data");
            try {
                String result = this.partialSave(entity, json);
                return new JSONObject(result);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new JSONObject();
    }
}

