package com.aote.rs;

import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;

/**
 * 提供sql查询服务
 */
@Path("sql")
@Component
@Transactional
public class SqlService {
	static Logger log = Logger.getLogger(SqlService.class);

	@Autowired
	private SqlServer sqlServer;

	/**
	 * 清理SQL源缓存
	 * @return ok
	 */
	@GET
	@Path("/clear")
	public String clearSQLCache(){
		ResourceHelper.clearSqlCache();
		return "ok";
	}

	/**
	 * 获取SQL语句的合计执行结果
	 *
	 * @param name
	 *            : sql语句名
	 * @param str
	 *            : sql语句执行参数
	 */
	@POST
	@Path("{name}/n")
	public String txgetTotalCnt(@PathParam("name") String name, String str)
			throws Exception {
		try {
			return sqlEncrypt(name, str, 1);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 执行sql,对sql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("{name}")
	public String txExecute(@PathParam("name") String name,
							@QueryParam("pageNo") int pageNo,
							@QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			return sqlEncrypt(name, str, 2, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 获取HQL语句的合计执行结果
	 *
	 * @param name
	 *            : hql语句名
	 * @param str
	 *            : hql语句执行参数
	 */
	@POST
	@Path("hql/{name}/n")
	public String txHqlgetTotalCnt(@PathParam("name") String name, String str)
			throws Exception {
		try {
			return sqlEncrypt(name, str, 3);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("hql/{name}")
	public String txHqlExecute(@PathParam("name") String name,
							   @QueryParam("pageNo") int pageNo,
							   @QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			return sqlEncrypt(name, str, 4, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 * 取消大于1000时限制1000的条件
	 */
	@POST
	@Path("hql/{name}/all")
	public String txHqlExecuteAll(@PathParam("name") String name,
								  @QueryParam("pageNo") int pageNo,
								  @QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			return sqlEncrypt(name, str, 5, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 封装sql
	 * @param sqlName sql名
	 * @param param	参数
	 * @param method 区分调用
	 * @param value	接收分页的两个参数
	 * @return
	 */
	private String sqlEncrypt(String sqlName, String param, int method, int ... value)throws Exception{
		switch (method){
			case 1:
				return sqlServer.queryTotal(sqlName, param).toString();
			case 2:
				return sqlServer.query(sqlName, value[0], value[1], param).toString();
			case 3:
				return sqlServer.queryHqlTotal(sqlName, param).toString();
			case 4:
				return sqlServer.hqlQuery(sqlName, value[0], value[1], param).toString();
			default:
				return sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString();
		}
	}
}
