/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.util.stream.Stream;

public enum ResourceType {
    LOGIC("logic"),
    SQL("sql"),
    PATH("path");

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public static ResourceType toType(String value) {
        return Stream.of(ResourceType.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
    }

    public static boolean is(String value) {
        return ResourceType.toType(value) != null;
    }

    public String getValue() {
        return this.value;
    }
}

