/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.exception.FileNotFoundException;
import com.aote.util.ResourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceHelper {
    private static final ConcurrentHashMap<String, String> cacheLogicMap = new ConcurrentHashMap(30);
    private static final ConcurrentHashMap<String, String> cacheSqlMap = new ConcurrentHashMap(30);
    private static final ConcurrentHashMap<String, String> cachePathMap = new ConcurrentHashMap(30);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String fileName) throws FileNotFoundException, IOException {
        String result;
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            String line;
            if (!fileName.startsWith("/")) {
                fileName = "/" + fileName;
            }
            if (null == (inputStream = ResourceHelper.class.getResourceAsStream(fileName))) {
                throw new FileNotFoundException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728", fileName);
            }
            br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            result = sb.toString();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    public static String getString(ResourceType resourceType, String alias, String fileName) throws FileNotFoundException, IOException {
        String source;
        switch (resourceType) {
            case LOGIC: {
                if (cacheLogicMap.containsKey(alias)) {
                    source = cacheLogicMap.get(alias);
                    break;
                }
                source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                cacheLogicMap.put(alias, source);
                break;
            }
            case SQL: {
                if (cacheSqlMap.containsKey(alias)) {
                    source = cacheSqlMap.get(alias);
                    break;
                }
                source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                source = "$" + source;
                cacheSqlMap.put(alias, source);
                break;
            }
            case PATH: {
                if (cachePathMap.containsKey(alias)) {
                    source = cachePathMap.get(alias);
                    break;
                }
                source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                source = "$" + source;
                cachePathMap.put(alias, source);
                break;
            }
            default: {
                throw new RuntimeException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
            }
        }
        return source;
    }

    public static void clearLogicCache() {
        cacheLogicMap.clear();
    }

    public static void clearSqlCache() {
        cacheSqlMap.clear();
    }
}

