/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.JsonTransfer;
import com.aote.util.ParamFilter;
import com.aote.util.ResourceHelper;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import com.aote.util.other.RSAUtil;
import java.util.Enumeration;
import java.util.Map;
import javassist.NotFoundException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    private LogicServer logicServer;

    public static void main(String[] args) {
    }

    @GET
    @Transactional
    @Path(value="{logic}")
    public String xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.xtSave(logicName, params.toString(), request);
    }

    @GET
    @Path(value="/clear")
    public String clearLogicCache() {
        ResourceHelper.clearLogicCache();
        return "ok";
    }

    @GET
    @Transactional
    @Async(value="AsyncLogicGet")
    @Path(value="async/{logic}")
    public String asyncXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.xtSave(logicName, params.toString(), request);
    }

    @POST
    @Transactional
    @Path(value="{logic}")
    public String xtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        JSONObject paramJson;
        log.info((Object)("logic:" + logicName + ", values:" + values));
        if (values.startsWith("$")) {
            values = RSAUtil.descrypt(values.substring(1));
            paramJson = new JSONObject(values);
        } else if (!values.startsWith("{")) {
            paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = headerNames.nextElement().toString();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        } else {
            paramJson = new JSONObject(values);
        }
        JSONObject configJson = JsonHelper.getConfig();
        Util.checkEncry(paramJson, configJson);
        boolean sqlInject = false;
        if (configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        switch (paramJson.get("aoteEncrypt").toString()) {
            case "AES": {
                String data = paramJson.getString("data");
                String encryKey = configJson.getString("encryKey");
                String decryptData = AESUtil.decrypt(data, encryKey);
                if (sqlInject) {
                    ParamFilter.checkSqlJsonStr(decryptData);
                }
                return AESUtil.encrypt(this.run(logicName, decryptData), encryKey);
            }
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(values);
        }
        return this.run(logicName, values);
    }

    @GET
    @Transactional
    @Path(value="standard/{logic}")
    public JSONObject standardXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return new JSONObject(this.xtSave(logicName, params.toString(), request));
    }

    @POST
    @Transactional
    @Path(value="standard/{logic}")
    public JSONObject standardXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        return new JSONObject(this.xtSave(logicName, values, request));
    }

    @POST
    @Async(value="AsyncLogicPost")
    @Transactional
    @Path(value="async/{logic}")
    public String asyncXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        JSONObject paramJson;
        log.info((Object)("logic:" + logicName + ", values:" + values));
        if (values.startsWith("$")) {
            values = RSAUtil.descrypt(values.substring(1));
            paramJson = new JSONObject(values);
        } else if (!values.startsWith("{")) {
            paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = headerNames.nextElement().toString();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        } else {
            paramJson = new JSONObject(values);
        }
        JSONObject configJson = JsonHelper.getConfig();
        Util.checkEncry(paramJson, configJson);
        boolean sqlInject = false;
        if (configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        switch (paramJson.get("aoteEncrypt").toString()) {
            case "AES": {
                String data = paramJson.getString("data");
                String encryKey = configJson.getString("encryKey");
                String decryptData = AESUtil.decrypt(data, encryKey);
                if (sqlInject) {
                    ParamFilter.checkSqlJsonStr(decryptData);
                }
                return AESUtil.encrypt(this.run(logicName, decryptData), encryKey);
            }
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(values);
        }
        return this.run(logicName, values);
    }

    @GET
    @Transactional
    @Path(value="debug/{logic}")
    public String debugXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.debugXtSave(logicName, params.toString(), request);
    }

    @POST
    @Transactional
    @Path(value="debug/{logic}")
    public String debugXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        JSONObject paramJson;
        log.info((Object)("logic:" + logicName + ", values:" + values));
        if (values.startsWith("$")) {
            values = RSAUtil.descrypt(values.substring(1));
            paramJson = new JSONObject(values);
        } else if (!values.startsWith("{")) {
            paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = headerNames.nextElement().toString();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        } else {
            paramJson = new JSONObject(values);
        }
        JSONObject configJson = JsonHelper.getConfig();
        Util.checkEncry(paramJson, configJson);
        boolean sqlInject = false;
        if (configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        switch (paramJson.get("aoteEncrypt").toString()) {
            case "AES": {
                String data = paramJson.getString("data");
                String encryKey = configJson.getString("encryKey");
                String decryptData = AESUtil.decrypt(data, encryKey);
                if (sqlInject) {
                    ParamFilter.checkSqlJsonStr(decryptData);
                }
                String string = AESUtil.encrypt(this.run(logicName, decryptData), encryKey);
            }
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(values);
        }
        String result = this.run(logicName, values);
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return result;
    }

    @Transactional
    public String xtSave(String logicName, String values) throws Exception {
        JSONObject paramJson;
        log.info((Object)("logic:" + logicName + ", values:" + values));
        if (values.startsWith("$")) {
            values = RSAUtil.descrypt(values.substring(1));
            paramJson = new JSONObject(values);
        } else if (!values.startsWith("{")) {
            paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            values = paramJson.toString();
        } else {
            paramJson = new JSONObject(values);
        }
        JSONObject configJson = JsonHelper.getConfig();
        Util.checkEncry(paramJson, configJson);
        boolean sqlInject = false;
        if (configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        switch (paramJson.get("aoteEncrypt").toString()) {
            case "AES": {
                String data = paramJson.getString("data");
                String encryKey = configJson.getString("encryKey");
                String decryptData = AESUtil.decrypt(data, encryKey);
                if (sqlInject) {
                    ParamFilter.checkSqlJsonStr(decryptData);
                }
                return AESUtil.encrypt(this.run(logicName, decryptData), encryKey);
            }
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(values);
        }
        return this.run(logicName, values);
    }

    private String run(String logicName, String values) throws Exception {
        try {
            JSONObject jsonObject = new JSONObject(values);
            if (jsonObject.has("action")) {
                int id = this.judgeAction(jsonObject);
                return id + "";
            }
            Object result = this.logicServer.run(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                Map map = (Map)result;
                JSONObject json = JsonTransfer.MapToJson(map);
                if (!json.isNull(" xml")) {
                    return (String)json.get("xml");
                }
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                if (!json.isNull("xml")) {
                    return json.getString("xml");
                }
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    @POST
    @Path(value="noTransc/{logic}")
    public String save(@PathParam(value="logic") String logicName, String values) throws Exception {
        log.info((Object)("logic:" + logicName + ", values:" + values));
        try {
            Object result = this.logicServer.noTranscRun(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                Map map = (Map)result;
                JSONObject json = JsonTransfer.MapToJson(map);
                if (!json.isNull("xml")) {
                    return (String)json.get("xml");
                }
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                if (!json.isNull("xml")) {
                    return json.getString("xml");
                }
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }

    @PostConstruct
    public void redisCacheLogic() throws Exception {
        this.logicServer.redisCacheLogic();
    }

    private int judgeAction(JSONObject jsonObject) throws NotFoundException {
        String actObj = (String)jsonObject.get("action");
        if ("begin".equals(actObj)) {
            int sessionid = this.sessionPool.createSession();
            return sessionid;
        }
        int sessionid = jsonObject.getInt("id");
        if ("commit".equals(jsonObject)) {
            this.sessionPool.commit(sessionid);
        } else if ("rollback".equals(jsonObject)) {
            this.sessionPool.rollback(sessionid);
        }
        return sessionid;
    }
}

