package com.aote.columns;

import com.aote.ThreadResource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 表格列映射器
 */
public class ColumnsMapper {

    private static final Logger LOGGER = Logger.getLogger(ColumnsMapper.class);
    private static Map<String, Map<String, String>> map;

    static {
        //初始化即加载
        loadMap();
    }

    public static String getColumns(String alias)
    {
        if(map.containsKey(alias)) {
            String result = getColumnsByUser(alias);
            if(result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        else {
            return null;
        }
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getColumnsByUser(String alias){
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        } else {
            String path = dir + "/columns/" + alias + ".json";
            return ColumnsMapper.class.getClassLoader().getResourceAsStream(path) != null ? path : null;
        }
    }

    private static void loadMap() {
        map = new HashMap<>();
        SAXReader reader = new SAXReader();
        InputStream module = ColumnsMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            if (module != null) {
                parseModule(module);
            }

            InputStream input = ColumnsMapper.class.getClassLoader().getResourceAsStream("columns.xml");
            if (input != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator<Element> it = root.elementIterator("columns");

                while (it.hasNext()) {
                    Element elm = it.next();
                    Map<String, String> columns = new HashMap<>();
                    String alias = elm.attribute("alias").getValue();
                    columns.put("alias", alias);
                    String path = elm.attribute("path").getValue();
                    columns.put("path", "columns/" + path);
                    String mobile = elm.attributeValue("mobile");
                    columns.put("mobile", mobile);
                    map.put(alias, columns);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        for (Iterator<Element> it = root.elementIterator("module"); it.hasNext();) {
            Element elm = it.next();
            String name = elm.attribute("name").getValue();
            String path = elm.attributeValue("path");
            putMap(name, reader, path);
            for (Iterator<Element> children = elm.elementIterator("module"); children.hasNext();) {
                Element childElm = children.next();
                String childname = childElm.attribute("name").getValue();
                putMap(childname, reader, name);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        InputStream moduleColumns = ColumnsMapper.class.getClassLoader().getResourceAsStream(parent == null ? name + "/columns.xml" : parent+"/"+name + "/columns.xml");
        if (moduleColumns != null) {
            Document docColumns = reader.read(moduleColumns);
            Element rootColumns = docColumns.getRootElement();
            for (Iterator<Element> item = rootColumns.elementIterator("columns"); item.hasNext();) {
                Element elmment = item.next();
                Map<String, String> params = new HashMap<>();
                String alias = elmment.attribute("alias").getValue();
                params.put("alias", alias);
                String path = elmment.attribute("path").getValue();
                params.put("path", (parent == null ? name + "/columns/" : parent + "/" + name + "/columns/")+ path);
                String mobile = elmment.attributeValue("mobile");
                params.put("mobile", mobile);
                // 验证别名是否重复
                if (map.containsKey(alias)){
                    throw new Exception("别名"+ alias + "已存在");
                }
                map.put(alias, params);
            }
        }
    }
}
