package com.aote.exception;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * 异常日志记录管理
 */
@Component
public class ExceptionLogManage {
    private static Logger LOGGER = Logger.getLogger(ExceptionLogManage.class);

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private SqlServer sqlServer;

    public void writeError(Exception e, String path) {
        HttpServletRequest request = ((ServletRequestAttributes)
                RequestContextHolder.getRequestAttributes()).getRequest();
        String serviceName = request.getContextPath();
        String errorInfo = ExceptionHelper.stackToString(e);
        int causedByIndex = errorInfo.lastIndexOf("Caused by");
        String title;
        if(causedByIndex != -1){
            title = errorInfo.substring(errorInfo.lastIndexOf("Caused by"));
        } else {
            title = e.getMessage();
        }
        JSONObject params = new JSONObject();
        params.put("f_service",serviceName);
        params.put("f_src",path);
        params.put("f_log_type","异常");
        params.put("f_error_title",title);
        params.put("f_error_msg",errorInfo);
        params.put("f_times",0);
        try {
            entityServer.partialSave("t_log",params);
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}
