package com.aote.queryparams;

/**
 * 数据模式
 *
 * @author Mr.river
 */
public class DataMode {
    /**
     * 生成查询表单项
     */
    private final boolean queryForm;
    /**
     * 生成表格列
     */
    private final boolean table;
    /**
     * 生成新增/修改表单项
     */
    private final boolean addOrEditForm;
    /**
     * 生成SQL查询项
     */
    private final boolean sqlQueryItem;
    /**
     * 生成SQL查询表达式
     */
    private final boolean sqlQueryCondition;

    public DataMode(boolean queryForm, boolean table, boolean addOrEditForm, boolean sqlQueryItem, boolean sqlQueryCondition) {
        this.queryForm = queryForm;
        this.table = table;
        this.addOrEditForm = addOrEditForm;
        this.sqlQueryItem = sqlQueryItem;
        this.sqlQueryCondition = sqlQueryCondition;
    }

    public boolean isQueryForm() {
        return queryForm;
    }

    public boolean isTable() {
        return table;
    }

    public boolean isAddOrEditForm() {
        return addOrEditForm;
    }

    public boolean isSqlQueryItem() {
        return sqlQueryItem;
    }

    public boolean isSqlQueryCondition() {
        return sqlQueryCondition;
    }
}
