/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams.enums;

import java.util.stream.Stream;

public enum FormTypeEnum {
    INPUT("input"),
    SELECT("select"),
    SELECTS("selects"),
    RANGE_PICKER("rangePicker"),
    MONTH_PICKER("monthPicker"),
    WEEK_PICKER("weekPicker"),
    DATE_PICKER("datePicker"),
    CASCADER("cascader"),
    TEXTAREA("textarea"),
    FILE("file"),
    IMAGE("image"),
    ADDRESS_SEARCH("addressSearch"),
    CITY_SELECT("citySelect");

    private final String value;

    private FormTypeEnum(String value) {
        this.value = value;
    }

    public static FormTypeEnum toType(String value) {
        return Stream.of(FormTypeEnum.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
    }

    public static boolean is(String value) {
        return FormTypeEnum.toType(value) != null;
    }

    public String getValue() {
        return this.value;
    }
}

