package product;

import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.type.StandardBasicTypes;

import java.sql.Types;

/**
 * 解决oracle中使用hibernate在某些条件下不能正确创建hibernate_sequence的问题
 */
public class MyOracle10gDialect extends Oracle10gDialect {
    public MyOracle10gDialect() {
        super();
        //对应hbibernate里面的数据类型，否则映射不正确！
        registerHibernateType(Types.NCHAR, StandardBasicTypes.CHARACTER.getName());
        registerHibernateType(Types.NCHAR, 1, StandardBasicTypes.CHARACTER.getName());
        registerHibernateType(Types.NCHAR, 255, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.NVARCHAR, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.LONGNVARCHAR, StandardBasicTypes.TEXT.getName());
        registerHibernateType(Types.NCLOB, StandardBasicTypes.CLOB.getName());
    }

    public String getQuerySequencesString() {
        return "select sequence_name from user_sequences";
    }
}
