/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.file.FileServer;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="file")
public class FileService {
    private static final Logger LOGGER = Logger.getLogger(FileService.class);
    @Autowired
    private FileServer fileServer;

    @POST
    @Path(value="/upload/{resUploadMode}")
    @Consumes(value={"multipart/form-data"})
    public Response upload(@FormDataParam(value="avatar") InputStream fileInputStream, @FormDataParam(value="avatar") FormDataContentDisposition disposition, @PathParam(value="resUploadMode") String resUploadMode) throws IOException {
        FileServer.FileUploadResult result = this.fileServer.uploadFile(fileInputStream, disposition, resUploadMode, null);
        if (result.getSuccess().booleanValue()) {
            return Response.ok().entity((Object)result).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result.getData()).build();
    }

    @POST
    @Path(value="/upload/{resUploadMode}/{pathKey}")
    @Consumes(value={"multipart/form-data"})
    public Response uploadByPathKey(@FormDataParam(value="avatar") InputStream fileInputStream, @FormDataParam(value="avatar") FormDataContentDisposition disposition, @PathParam(value="resUploadMode") String resUploadMode, @PathParam(value="pathKey") String pathKey) throws IOException {
        FileServer.FileUploadResult result = this.fileServer.uploadFile(fileInputStream, disposition, resUploadMode, pathKey);
        if (result.getSuccess().booleanValue()) {
            return Response.ok().entity((Object)result).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result.getData()).build();
    }
}

