/*
 * Decompiled with CFR 0.152.
 */
package com.aote.file;

import com.aote.config.SystemConfig;
import com.aote.rs.enums.ResUploadModeEnum;
import com.aote.util.other.Base64Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.springframework.stereotype.Component;

@Component
public class FileServer {
    private static final Logger LOGGER = Logger.getLogger(FileServer.class);

    public FileUploadResult uploadFile(InputStream fileInputStream, FormDataContentDisposition disposition, String resUploadMode, String extraPathKey) throws IOException {
        FileUploadResult result;
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resUploadMode);
        if (resUploadTypeEnum == null) {
            return new FileUploadResult(false, "\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resUploadMode);
        }
        switch (resUploadTypeEnum) {
            default: {
                String fileName = this.uploadFileToServer(fileInputStream, disposition, extraPathKey);
                result = new FileUploadResult(true, fileName);
                break;
            }
            case BASE64: {
                String base64 = this.uploadFileToBase64(fileInputStream);
                result = new FileUploadResult(true, base64);
                break;
            }
            case OSS: {
                String ossResult = this.uploadFileToOSS(fileInputStream, disposition);
                result = new FileUploadResult(true, ossResult);
            }
        }
        return result;
    }

    public String uploadFileToServer(InputStream fileInputStream, FormDataContentDisposition disposition, String extraPathKey) throws IOException {
        String fileSuffix = disposition.getFileName().substring(disposition.getFileName().lastIndexOf(46) + 1);
        String path = SystemConfig.Resources.getFileRootPath();
        if (extraPathKey != null) {
            path = path + SystemConfig.Resources.getExtraPath(extraPathKey);
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(date);
        path = path + "\\" + formatDate;
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String fileName = uuid + "." + fileSuffix;
        path = path + "\\" + fileName;
        File fileDir = new File(path);
        FileUtils.copyToFile((InputStream)fileInputStream, (File)fileDir);
        return fileName;
    }

    public String uploadFileToBase64(InputStream fileInputStream) throws IOException {
        return Base64Utils.encode(IOUtils.toByteArray((InputStream)fileInputStream));
    }

    public String uploadFileToOSS(InputStream fileInputStream, FormDataContentDisposition disposition) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0OSS\u5bf9\u8c61\u5b58\u50a8\u6a21\u5f0f");
    }

    public static class FileUploadResult {
        private final Boolean isSuccess;
        private final String data;

        private FileUploadResult(boolean isSuccess, String data) {
            this.isSuccess = isSuccess;
            this.data = data;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public String getData() {
            return this.data;
        }
    }
}

