/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.af.plugins.JwtTools;
import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class LoginFilter
implements Filter {
    static Logger log = Logger.getLogger(LoginFilter.class);

    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ThreadResource.LoginUser.set(null);
        ThreadResource.ComponentDir.set(null);
        ThreadResource.Token.set(null);
        HttpServletRequest req = (HttpServletRequest)request;
        String sessionId = req.getHeader("session");
        ThreadResource.SessionId.set(sessionId == null ? null : new Integer(sessionId));
        String componentDir = req.getHeader("componentDir");
        log.debug((Object)("\u83b7\u53d6\u7684componentDir" + componentDir));
        if (componentDir != null) {
            ThreadResource.ComponentDir.set(componentDir);
            chain.doFilter(request, response);
            return;
        }
        String Token = req.getHeader("Token");
        log.debug((Object)("\u83b7\u53d6\u7684Token" + Token));
        if (Token == null) {
            chain.doFilter(request, response);
            return;
        }
        ThreadResource.Token.set(Token);
        try {
            JwtTools jt = new JwtTools();
            Claims claims = jt.parseJWT(Token);
            String loginId = (String)claims.get((Object)"userid");
            log.debug((Object)("loginId=" + loginId));
            if (loginId == null) {
                chain.doFilter(request, response);
                return;
            }
            RestTools rest = new RestTools();
            String str = RestTools.post((String)"/rs/search", (String)("{source:'this.getInfo()',userid:'" + loginId + "'}"));
            log.debug((Object)("\u7528\u6237\u4fe1\u606f\uff1a" + str));
            JSONObject json = new JSONObject(str);
            ThreadResource.LoginUser.set(json);
            String res = json.getString("dir");
            log.debug((Object)("\u7ec4\u4ef6\u76ee\u5f55\uff1a" + res));
            if (res != null && !"null".equals(res)) {
                ThreadResource.ComponentDir.set(res);
            }
            log.debug((Object)("-----\u8bf7\u6c42\u5730\u5740\uff1a" + req.getRequestURI() + "-----"));
            log.debug((Object)"\u8fdb\u5165chain.doFilter");
            chain.doFilter(request, response);
            log.debug((Object)"\u51fa\u5165chain.doFilter");
        }
        catch (ServletException e) {
            log.error((Object)"\u62e6\u622a\u5668\u65e5\u5fd7ServletException\uff1a", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.error((Object)"\u62e6\u622a\u5668\u65e5\u5fd7Throwable\uff1a", e);
            throw new ServletException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0cToken=" + Token, e);
        }
    }

    public void destroy() {
    }
}

