package com.aote.util;

import com.af.plugins.RedisTools;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import redis.clients.jedis.Jedis;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/**
 * 操作Jwt的工具类
 */
public class JwtUtil {
    /**
     * token密钥
     */
    private final String TOKEN_SECRET = "05b5d4c183c559d9a440f416cd08d3b1";

    private static String redisPassWord = "123456";

    static {
        try {
            String strConfig = ResourceHelper.getString("config.json");
            JSONObject jsonObject = new JSONObject(strConfig);
            if (jsonObject.has("logicRegister")) {
                //获取模块镜像IP和端口号
                JSONObject logicJsonObject = jsonObject.getJSONObject("logicRegister");
                JSONObject redisObject = logicJsonObject.getJSONObject("redis");
                redisPassWord = redisObject.getString("redispwd");
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



    public String getToken(String id,String eName,String pwd) {
        //token加密算法
        Algorithm algorithm = null;
        try {
            algorithm = Algorithm.HMAC256(TOKEN_SECRET);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Map<String,Object> hand = new HashMap<>(2);
        hand.put("type","JWT");
        hand.put("alg","HMAC256");

        String token =  JWT.create()
                .withHeader(hand)
                .withClaim("Id",id)
                .withClaim("eName",eName)
                .withClaim("password",pwd)
                .sign(algorithm);
        RedisTools.setValueByExpire(id+":"+eName,token,redisPassWord,"86400");
        return  token;
    }

    public boolean tokenVerify(String token){
        try {
            JWTVerifier jwtVerifier = JWT.require(Algorithm.HMAC256(TOKEN_SECRET)).build();
            DecodedJWT ver = jwtVerifier.verify(token);
            String id= ver.getClaim("Id").asString();
            String eName= ver.getClaim("eName").asString();

            Jedis jedis =RedisTools.getJedis();
            jedis.auth(redisPassWord);
            String saveToken = jedis.get(id+":"+eName);

            if(StringUtils.isBlank(saveToken)){
                return false;
            }else {
                return saveToken.equals(token);
            }
        }catch (Exception e){
            return false;
        }
    }

    public String getLoginId(String token){
        JWTVerifier jwtVerifier = null;
        try {
            jwtVerifier = JWT.require(Algorithm.HMAC256(TOKEN_SECRET)).build();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        DecodedJWT ver = jwtVerifier.verify(token);
        return ver.getClaim("Id").asString();
    }

}
