package com.aote.listener;

import com.aote.rs.ManagerService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.util.ArrayList;
import java.util.Properties;

public class KafkaConsumerListener implements ServletContextListener {

    private static KafkaConsumer<String, String> consumer = null;

    public static synchronized KafkaConsumer<String, String> getConsumer(){
        if (consumer == null) {
            initKafkaConsumer();
        }
        return consumer;
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("===============================KafkaConsumerListener");
        initKafkaConsumer();
//        if (consumer != null) {
//            while (true) {
//                //读取数据，读取超时时间为100ms
//                ConsumerRecords<String, String> records = consumer.poll(100);
//                //数据一般包含多条
//                for (ConsumerRecord<String, String> record : records)
//                    System.out.printf("offset = %d, key = %s, value = %s%n", record.offset(), record.key(), record.value());
//            }
//        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (consumer != null) {
            consumer.close();
        }
    }

    private static void initKafkaConsumer(){
        Properties props = new Properties();
        ManagerService ms = new ManagerService();
        JSONObject config = new JSONObject(ms.getConfig());
        // 如果配置了kafka的server及topics，根据配置内容对topic进行处理
        if (!config.has("kafka")) {
            return;
        }
        JSONObject kafka = config.getJSONObject("kafka");
        if (!kafka.has("server") || !kafka.has("topics")) {
            return;
        }
        try {
            // 设置server
            String servers = kafka.getString("server");
            props.put("bootstrap.servers", servers);
            props.put("group.id", "g1");
            props.put("enable.auto.commit", "true");
            props.put("auto.commit.interval.ms", "1000");
            props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            consumer = new KafkaConsumer<>(props);
            //消费者订阅的主题，可同时订阅多个
            ArrayList<String> topics = new ArrayList<>();
            JSONArray arr = kafka.getJSONArray("topics");
            for (int i = 0; i < arr.length(); i++){
                topics.add(arr.getString(i));
            }
            consumer.subscribe(topics);
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
