package com.aote.filter;

import com.af.plugins.JwtUtil;
import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import com.aote.rs.mapper.WebException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;

public class LoginFilter implements Filter {
    static Logger log = Logger.getLogger(LoginFilter.class);

    /**
     * 从cookie里获取给定主键的内容
     * @param key
     * @return
     */
    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for(Cookie cookie : request.getCookies()) {
            if (cookie.getName().equals(key)) {
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 清除线程变量
        ThreadResource.LoginUser.set(null);
        ThreadResource.ComponentDir.set(null);
        ThreadResource.Token.set(null);
        HttpServletRequest req =(HttpServletRequest) request;

        String url = req.getRequestURL().toString().toLowerCase();
        log.debug("传入的URL"+url);

        boolean isOk = false;
        String Token = null;
        String loginId;
        //登录请求判断
        if(this.isPassUri(url)){
            isOk = true;
        } else if(req.getHeader("appToken") != null) {
            //APP请求判断
            String appToken = req.getHeader("appToken");
            if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                isOk = true;
            }
        } else if(req.getHeader("Authorization") != null){
            // 从请求头中获取Token
            Token = req.getHeader("Authorization");
            log.debug("获取的Token" + Token);
            if (Token != null) {
                Token = Token.substring(7);
                JwtUtil jwtUtil = new JwtUtil();
                if (jwtUtil.tokenVerify(Token)) {
                    isOk = true;
                }
            }
        }
        if(!isOk){
            throw new WebException(401,"用户认证失败！");
        }
        //获取登陆人
        loginId = getLoginId(req.getHeader("Token"),req.getHeader("Authorization"));
        if(loginId == null){
            chain.doFilter(request, response);
            return;
        }
        if(req.getHeader("Token") != null){
            Token = req.getHeader("Token");
        }
        // 把token传递下去
        if(Token != null) {
            ThreadResource.Token.set(Token);
        }
        // 从请求头获取sessionid
        String sessionId = req.getHeader("session");
        ThreadResource.SessionId.set(sessionId == null ? null : new Integer(sessionId));

        // 从请求头获取公司目录配置
        String componentDir = req.getHeader("componentDir");
        log.debug("获取的componentDir" + componentDir);
        // 如果有公司目录配置，不管人，直接把公司目录放到线程变量里
        if (componentDir != null) {
            ThreadResource.ComponentDir.set(componentDir);
            chain.doFilter(request, response);
            return;
        }

        try {
            // 根据用户id从ldap中获取业务逻辑等内容存放路径·
            // RestTools rest = new RestTools();
            String str = RestTools.post("/rs/search", "{source:'this.getInfo()',userid:'" + loginId + "'}");
            log.debug("用户信息：" + str);
            JSONObject json = new JSONObject(str);
            // 把用户完整信息存放到线程变量里
            ThreadResource.LoginUser.set(json);

            String res = json.getString("dir");
            log.debug("组件目录：" + res);
            if (res != null && !"null".equals(res)) {
                // 把存放路径放到线程变量中，供其他地方调用
                ThreadResource.ComponentDir.set(res);
            }
			log.debug("进入chain.doFilter");
			chain.doFilter(request, response);
			log.debug("出入chain.doFilter");
        } catch (ServletException e) {
            log.error("拦截器日志ServletException：",e);
            throw e;
        } catch (Throwable e) {
            log.error("拦截器日志Throwable：",e);
            throw new ServletException("获取用户信息错误，Token=" + Token, e);
        }
   }

    @Override
    public void destroy() {
    }


    public boolean isPassUri(String url){
        for(String item : PassUrl.PASSURL_ARRAY){
            if(url.contains(item)){
                return true;
            }
        }
        return false;
    }

    public String getLoginId(String token,String auth){
        if(token != null){
            return token;
        } else if(auth != null){
            auth = auth.substring(7);
            //获取Token中用户id
            return new JwtUtil().getLoginId(auth);
        } else {
            return null;
        }
    }
}
