package com.aote.filter;

import com.af.plugins.JwtUtil;
import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import com.aote.rs.mapper.WebException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;

public class LdapFilter implements Filter {
    static Logger log = Logger.getLogger(LdapFilter.class);

    /**
     * 从cookie里获取给定主键的内容
     * @param key
     * @return
     */
    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for(Cookie cookie : request.getCookies()) {
            if (cookie.getName().equals(key)) {
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 清除线程变量
        ThreadResource.LoginUser.set(null);
        ThreadResource.ComponentDir.set(null);
        ThreadResource.Token.set(null);
        HttpServletRequest req =(HttpServletRequest) request;

        String url = req.getRequestURL().toString().toLowerCase();
        log.debug("传入的URL"+url);

        boolean isOk = false;
        String Token = null;
        String loginId;
        //登录请求判断
        if(this.isPassUri(url)){
            isOk = true;
        } else if(req.getHeader("appToken") != null) {
            //APP请求判断
            String appToken = req.getHeader("appToken");
            if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                isOk = true;
            }
        } else if(req.getHeader("Authorization") != null){
            // 从请求头中获取Token
            Token = req.getHeader("Authorization");
            log.debug("获取的Token" + Token);
            if (Token != null) {
                Token = Token.substring(7);
                JwtUtil jwtUtil = new JwtUtil();
                if (jwtUtil.tokenVerify(Token)) {
                    isOk = true;
                }
            }
        }
        if(!isOk){
            throw new WebException(401,"用户认证失败！");
        }
        log.debug("进入chain.doFilter");
        chain.doFilter(request, response);
        log.debug("出入chain.doFilter");
    }

    @Override
    public void destroy() {
    }


    public boolean isPassUri(String url){
        for(String item : PassUrl.PASSURL_ARRAY){
            if(url.contains(item)){
                return true;
            }
        }
        return false;
    }

    public String getLoginId(String token,String auth){
        if(token != null){
            return token;
        } else if(auth != null){
            auth = auth.substring(7);
            //获取Token中用户id
            return new JwtUtil().getLoginId(auth);
        } else {
            return null;
        }
    }
}
