/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.util.ExceptionHelper;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="entity")
@Singleton
@Component
@Transactional
public class EntityService {
    static Logger log = Logger.getLogger(EntityService.class);
    @Autowired
    private EntityServer entityServer;

    @POST
    @Path(value="{entity}")
    public String xtSave(@PathParam(value="entity") String entityName, String values) throws Exception {
        log.debug((Object)("entity:" + entityName + ", values:" + values));
        try {
            return this.entityServer.partialSave(entityName, values);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @DELETE
    @Path(value="{entity}/{id}")
    public String txDelete(@PathParam(value="entity") String entityName, @PathParam(value="id") String id) throws Exception {
        try {
            return this.entityServer.delete(entityName, id);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @PostConstruct
    public void init() {
        this.entityServer.loadMetaData();
    }
}

