/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.module.ModuleMapper;
import com.aote.sql.SqlMapper;
import com.aote.util.ResourceHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PluginMapper
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    static Logger log;
    private static Map<String, Object> map;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        applicationContext = ctx;
    }

    public static Map<String, Object> getPlugins() {
        if (map == null) {
            map = PluginMapper.loadMap();
        }
        return map;
    }

    private static Map<String, Object> loadMap() {
        Map<String, Object> result = PluginMapper.innerLoadMap("");
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        for (String key : map.keySet()) {
            Map<String, Object> plugins = PluginMapper.innerLoadMap(key);
            result.putAll(plugins);
        }
        return result;
    }

    private static Map<String, Object> innerLoadMap(String module) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!"".equals(module)) {
            module = module + "/";
        }
        if (ResourceHelper.class.getResourceAsStream("/" + module + "plugins.xml") == null) {
            log.debug((Object)"\u65e0plugins.xml\u6587\u4ef6");
            return map;
        }
        SAXReader reader = new SAXReader();
        InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream(module + "plugins.xml");
        try {
            Document document = reader.read(input);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("plugin");
            while (it.hasNext()) {
                Element elm = (Element)it.next();
                String alias = elm.attribute("alias").getValue();
                String className = elm.attribute("class").getValue();
                Class<?> c = Class.forName(className);
                Object obj = elm.attribute("spring") != null ? applicationContext.getBean(c) : c.newInstance();
                map.put(alias, obj);
            }
            return map;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("\u672a\u627e\u5230\u7c7b, \u6a21\u5757=" + module + ", \u7c7b=" + ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void main(String[] args) {
        PluginMapper.loadMap();
        for (String key : map.keySet()) {
            System.out.println(key);
        }
    }

    static {
        log = Logger.getLogger(PluginMapper.class);
        map = null;
    }
}

