package com.aote.timer;

import com.af.plugins.JsonTools;
import com.af.plugins.iot.WebMeterInfo;
import com.aote.logic.LogicServer;
import com.aote.module.ModuleMapper;
import com.aote.util.ResourceHelper;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

import static com.aote.listener.KafkaConsumerListener.getConsumer;

/**
 * kafka消费者定时器
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class KafkaConsumerTimer {

    private static Logger log = Logger.getLogger(KafkaConsumerTimer.class);

    @Autowired
    private LogicServer logicServer;
    /**
     * 业务列表
     */
    private Map<String,JSONArray> businessList = new HashMap<>();

    private JSONArray jsonArray = new JSONArray();

    public KafkaConsumerTimer() {
        load();
    }
    /**
     * 读取业务配置文件
     */
    public void load(){
        try {
            // 获取所有引入的模块名
            Map<String, Map<String, String>> map = ModuleMapper.getMap();
            for(String moduleName : map.keySet()) {
                if (ResourceHelper.class.getClassLoader().getResourceAsStream( moduleName + "/saveBusiness.json") != null){
                    JSONArray business = JsonTools.readJsonArrayFile(moduleName + "/saveBusiness.json");
                    businessList.put(moduleName,business);
                }
            }

        } catch (Exception e){
            log.error("请检查module.xml和business.json文件配置!");
            throw new RuntimeException(e);
        }
    }

    /**
     * 执行业务
     */
    public void doBusiness() {
        JSONArray jsonArray = new JSONArray();
        KafkaConsumer<String, String> consumer = getConsumer();
        //读取数据，读取超时时间为100ms
        ConsumerRecords<String, String> records = consumer.poll(100);
        //数据一般包含多条
        for (ConsumerRecord<String, String> record : records) {
            System.out.printf("offset = %d, key = %s, value = %s%n", record.offset(), record.key(), record.value());
            JSONObject jsonObject = new JSONObject(new String(record.value()));
            jsonArray.put(jsonObject);
        }

        System.out.println(jsonArray.length());

        if(jsonArray.length() == 0)
            return;

        for (Map.Entry<String, JSONArray> entry : businessList.entrySet()) {
            //设置模块名
            String moduleName = entry.getKey();
            //WebMeterInfo.setModuleName(moduleName);
            for(int i = 0; i<entry.getValue().length(); i++){
                JSONObject business = entry.getValue().getJSONObject(i);
                //业务名称
                String businessName = business.getString("name");
                //业务逻辑名称
                String logicName = business.getString("logicName");
                //传入的数据
                JSONObject data = new JSONObject();
                data.put("data", jsonArray);
                //开始执行业务
                log.info("开始执行======模块：【"+moduleName+"】==>【"+businessName+"】业务======");
                try {
                    logicServer.run(logicName, data);
                } catch (Exception e) {
                    log.info("执行失败=====模块：【"+moduleName+"】==>【"+businessName+"】业务======");
                    throw new RuntimeException(e);
                }
                log.info("执行成功======模块：【"+moduleName+"】==>【"+businessName+"】业务======");
            }
        }
    }
}
