package com.aote.rs;

import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.util.ExceptionHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

/**
 * 提供path查询服务
 */
@Path("path")
@Component
@Transactional
public class PathService {
	static Logger log = Logger.getLogger(PathService.class);

	@Autowired
	private PathServer pathServer;

	/**
	 * 获取path查询的总数
	 * @param name path查询
	 * @param str 查询所需参数
	 * @return 总数
	 */
	@POST
	@Path("{name}/n")
	public String txgetTotalCnt(@PathParam("name") String name, String str)
			throws Exception {
		try {
			JSONObject result = pathServer.queryTotal(name, str);
			return result.toString();
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 执行path,对path中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("{name}")
	public String txPath(@PathParam("name") String name,
			@QueryParam("pageNo") int pageNo,
			@QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			String level = PathMapper.getAttr(name, "log");
			if (level != null) {
				log.debug(name + ":" + str);
			}
			JSONArray result = pathServer.query(name, pageNo, pageSize, str);
			String ret = result.toString();
			if (level != null) {
				log.debug(name + ":" + ret);
			}
			return ret;
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}
}
