package com.aote.logic;

import com.aote.module.ModuleMapper;
import com.aote.sql.SqlMapper;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 业务插件映射器
 * @author HNS
 *
 */
@Component
public class PluginMapper implements ApplicationContextAware
 {
 	//注意是static的
	private static ApplicationContext applicationContext;

	static Logger log = Logger.getLogger(PluginMapper.class);
	
	private static Map<String, Object> map = null;

	 /**
	  * Spring启动的时候会自动调用下面的方法设置ApplicationContext的值
	  */
	 @Override
	 public void setApplicationContext(ApplicationContext ctx) throws BeansException {
		 applicationContext = ctx;
	 }

	public static Map<String, Object> getPlugins() {
		if(map == null) {
			map = loadMap();
		}
		return map;
	}

	@SuppressWarnings("rawtypes")
	private static Map<String, Object> loadMap() {
		// 先获取自身的插件
		Map<String, Object> result = innerLoadMap("");
		// 获取所有模块的插件
		Map<String, Map<String, String>> map = ModuleMapper.getMap();
		for(String key  :  map.keySet()) {
			Map<String, Object> plugins = innerLoadMap(key);
			result.putAll(plugins);
		}
		return result;
	}

	private static Map<String, Object> innerLoadMap(String module) {
		Map<String, Object> map = new HashMap<>();

		// module要添加路径分隔符
		if (!"".equals(module)) {
			module += "/";
		}
		if (ResourceHelper.class.getResourceAsStream("/" + module + "plugins.xml") == null) {
			log.debug("无plugins.xml文件");
			return map;
		}

		SAXReader reader = new SAXReader();
		InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream(module + "plugins.xml");
		try {
			Document document = reader.read(input);
			Element root = document.getRootElement();
			for (Iterator it = root.elementIterator("plugin"); it.hasNext();) {
				Element elm = (Element) it.next();
				String alias = elm.attribute("alias").getValue();
				String className = elm.attribute("class").getValue();
				Class c = Class.forName(className);
				Object obj;
				// 如果是spring的bean，让spring取
				if(elm.attribute("spring") != null) {
					obj = applicationContext.getBean(c);
				} else {
					obj = c.newInstance();
				}
				map.put(alias, obj);
			}
			return map;
		} catch (ClassNotFoundException ex) {
			throw new RuntimeException("未找到类, 模块=" + module + ", 类=" + ex.getMessage());
		} catch (RuntimeException ex) {
			throw ex;
		} catch (Throwable ex) {
			throw new RuntimeException(ex);
		}
	}

	public void main(String[] args) {
		PluginMapper.loadMap();
		for(String key : map.keySet()) {
			System.out.println(key);
		}
	}
}
