package com.aote.entity;


import com.aote.exception.FileNotFoundException;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;

/**
 * 对实体规则（可参考可模块下的rules.config）进行验证
 *
 */
public class RulesValidation {

    static Logger log = Logger.getLogger(EntityServer.class);
    /**
     * 对即将保存或者更新的数据进行规则验证
     *
     * @param obj 即将保存的对象
     * @param entityName 实体对象
     * @param type  操作类型（update/insert）
     * @throws IOException
     */
    public static void ruleValidation(JSONObject obj, String entityName, String type) throws Exception {
        // 获取规则配置文件
        String getConfig = null;
        try {
            getConfig = ResourceHelper.getString("rules.json");
        } catch (FileNotFoundException e) {
            // 将异常吞掉，不做抛出处理
            log.debug("无规则配置文件,不进行验证");
            return;
        } catch (IOException e) {
            throw e;
        }
        // 解析规则配置文件
        JSONObject rules = new JSONObject(getConfig);
        JSONObject getEntityRules = null;
        try {
            getEntityRules = (JSONObject)rules.get(entityName);
        } catch (JSONException e) {
            log.debug("该对象不需要验证");
            return;
        }

        // 验证
        // 获取每个字段
        for(String field : getEntityRules.keySet()) {
            // 对每个字段进行验证
            JSONObject getField = (JSONObject)getEntityRules.get(field);
            for(String str : getField.keySet()) {
                switch (str) {
                    case "update":
                        updateValidate(field, obj, getField.get(str));
                        break;
                    case "enum":
                        enumValidate(field, obj, getField.get(str));
                        break;
                    case "expression":
                        expreValidate(field, obj, getField.get(str));
                        break;
                }
            }
        }

    }

    /**
     * 对于更新的规则验证
     *
     * @param key 要验证的字段
     * @param entity 要保存或者更新的实体
     * @param updateObj
     * @throws Exception
     */
    private static void updateValidate(String key, JSONObject entity, Object updateObj) throws Exception{
        if (updateObj instanceof String) {
            if ("false".equals(updateObj)) {
                // 判断即将持久化的数据中该字段不允许更新
                if (entity.has(key)) {
                    log.error("该字段" + key + "根据规则。不能执行更新操作");
                    throw new Exception("该字段" + key + "根据规则。不能执行更新操作");
                }
            }
        }
        if (updateObj instanceof Boolean) {
            if (!(Boolean) updateObj) {
                if (entity.has(key)) {
                    log.error("该字段" + key + "根据规则。不能执行更新操作");
                    throw new Exception("该字段" + key + "根据规则。不能执行更新操作");
                }
            }
        }
        if (updateObj instanceof JSONObject) {
            // TODO 之后对某个功能的赦免再次验证
            throw new Exception("该字段的规则还未开发");
        }
    }

    /**
     * 对于枚举的规则验证
     *
     * @param key 要验证的字段
     * @param entity 要保存或者更新的实体
     * @param enumObj
     * @throws Exception
     */
    private static void enumValidate(String key, JSONObject entity, Object enumObj) throws Exception {
        // 此值必须是数组类型否则抛出异常
        if(enumObj instanceof JSONArray) {
            if (!enumObj.toString().contains(entity.get(key).toString())) {
                log.error("该字段" + key + "应处于" + enumObj.toString());
                throw new Exception("该字段" + key + "应处于" + enumObj.toString());
            }
        }
    }

    /**
     * 对于表达式的规则验证
     *
     * @param key 要验证的字段
     * @param entity 要保存或者更新的实体
     * @param expreObj
     */
    private static void expreValidate(String key, JSONObject entity, Object expreObj) {

    }

}
